/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.spooling.encoding;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.client.QueryDataDecoder;
import io.trino.client.spooling.encoding.JsonQueryDataDecoder;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class QueryDataDecoders {
    private static final List<QueryDataDecoder.Factory> decoders = ImmutableList.of((Object)new JsonQueryDataDecoder.Factory(), (Object)new JsonQueryDataDecoder.ZstdFactory(), (Object)new JsonQueryDataDecoder.Lz4Factory());
    private static final Map<String, QueryDataDecoder.Factory> encodingMap = QueryDataDecoders.factoriesMap();

    private QueryDataDecoders() {
    }

    public static QueryDataDecoder.Factory get(String encodingId) {
        if (!encodingMap.containsKey(encodingId)) {
            throw new IllegalArgumentException("Unknown encoding id: " + encodingId);
        }
        QueryDataDecoder.Factory factory = encodingMap.get(encodingId);
        Verify.verify((boolean)factory.encodingId().equals(encodingId), (String)"Factory has wrong encoding id, expected %s, got %s", (Object)encodingId, (Object)factory.encodingId());
        return factory;
    }

    private static Map<String, QueryDataDecoder.Factory> factoriesMap() {
        return (Map)decoders.stream().collect(ImmutableMap.toImmutableMap(QueryDataDecoder.Factory::encodingId, Function.identity()));
    }
}

