/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.spooling;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.trino.client.spooling.DataAttribute;
import io.trino.client.spooling.DataAttributes;
import io.trino.client.spooling.InlineSegment;
import io.trino.client.spooling.SpooledSegment;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=InlineSegment.class, name="inline"), @JsonSubTypes.Type(value=SpooledSegment.class, name="spooled")})
public abstract class Segment {
    private final DataAttributes metadata;

    public Segment(DataAttributes metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @JsonProperty(value="metadata")
    public Map<String, Object> getJsonMetadata() {
        return this.metadata.attributes;
    }

    @JsonIgnore
    public DataAttributes getMetadata() {
        return this.metadata;
    }

    @JsonIgnore
    public long getOffset() {
        return this.getRequiredAttribute(DataAttribute.ROW_OFFSET, Long.class);
    }

    @JsonIgnore
    public long getRowsCount() {
        return this.getRequiredAttribute(DataAttribute.ROWS_COUNT, Long.class);
    }

    @JsonIgnore
    public int getSegmentSize() {
        return this.getRequiredAttribute(DataAttribute.SEGMENT_SIZE, Integer.class);
    }

    public <T> Optional<T> getAttribute(DataAttribute name, Class<T> clazz) {
        return Optional.ofNullable(this.metadata.get(name, clazz));
    }

    public <T> T getRequiredAttribute(DataAttribute name, Class<T> clazz) {
        return this.getAttribute(name, clazz).orElseThrow(() -> new IllegalArgumentException("Missing required attribute: " + name.attributeName()));
    }

    public static Segment inlined(byte[] data, DataAttributes attributes) {
        return new InlineSegment(data, attributes);
    }

    public static Segment spooled(URI segmentUri, DataAttributes attributes, Map<String, List<String>> headers) {
        return new SpooledSegment(segmentUri, attributes, headers);
    }
}

