/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.spooling.encoding;

import io.trino.client.QueryDataDecoder;
import io.trino.client.spooling.DataAttribute;
import io.trino.client.spooling.DataAttributes;
import io.trino.client.spooling.encoding.QueryDataAccess;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;

public abstract class CompressedQueryDataDecoder
implements QueryDataDecoder {
    protected final QueryDataDecoder delegate;

    public CompressedQueryDataDecoder(QueryDataDecoder delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    abstract InputStream decompress(InputStream var1, int var2) throws IOException;

    @Override
    public QueryDataAccess decode(InputStream stream, DataAttributes metadata) throws IOException {
        Optional<Integer> expectedDecompressedSize = metadata.getOptional(DataAttribute.UNCOMPRESSED_SIZE, Integer.class);
        if (expectedDecompressedSize.isPresent()) {
            return this.delegate.decode(this.decompress(stream, expectedDecompressedSize.get()), metadata);
        }
        return this.delegate.decode(stream, metadata);
    }
}

