/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.spooling.encoding;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.client.QueryDataDecoder;
import io.trino.client.spooling.encoding.JsonQueryDataDecoder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class QueryDataDecoders {
    private static final List<QueryDataDecoder.Factory> decoders = ImmutableList.of((Object)new JsonQueryDataDecoder.Factory(), (Object)new JsonQueryDataDecoder.ZstdFactory(), (Object)new JsonQueryDataDecoder.Lz4Factory());
    private static final Map<String, QueryDataDecoder.Factory> encodingMap = QueryDataDecoders.factoriesMap();

    private QueryDataDecoders() {
    }

    public static QueryDataDecoder.Factory get(String encoding) {
        if (!encodingMap.containsKey(encoding)) {
            throw new IllegalArgumentException("Unknown encoding: " + encoding);
        }
        QueryDataDecoder.Factory factory = encodingMap.get(encoding);
        Verify.verify((boolean)factory.encoding().equals(encoding), (String)"Factory has wrong encoding, expected %s, got %s", (Object)encoding, (Object)factory.encoding());
        return factory;
    }

    public static boolean exists(String encoding) {
        return encodingMap.containsKey(encoding);
    }

    public static Set<String> getSupportedEncodings() {
        return encodingMap.keySet();
    }

    private static Map<String, QueryDataDecoder.Factory> factoriesMap() {
        return (Map)decoders.stream().collect(ImmutableMap.toImmutableMap(QueryDataDecoder.Factory::encoding, Function.identity()));
    }
}

