/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.spooling.encoding;

import com.google.common.io.ByteStreams;
import io.airlift.compress.zstd.ZstdDecompressor;
import io.trino.client.QueryDataDecoder;
import io.trino.client.spooling.encoding.CompressedQueryDataDecoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZstdQueryDataDecoder
extends CompressedQueryDataDecoder {
    public ZstdQueryDataDecoder(QueryDataDecoder delegate) {
        super(delegate);
    }

    @Override
    InputStream decompress(InputStream stream, int expectedDecompressedSize) throws IOException {
        byte[] output;
        ZstdDecompressor decompressor = new ZstdDecompressor();
        byte[] bytes = ByteStreams.toByteArray((InputStream)stream);
        int decompressedSize = decompressor.decompress(bytes, 0, bytes.length, output = new byte[expectedDecompressedSize], 0, output.length);
        if (decompressedSize != expectedDecompressedSize) {
            throw new IOException(String.format("Decompressed size does not match expected segment size, expected %d, got %d", decompressedSize, expectedDecompressedSize));
        }
        return new ByteArrayInputStream(output);
    }

    @Override
    public String encoding() {
        return this.delegate.encoding() + "+zstd";
    }
}

