/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.base.Preconditions;
import io.trino.client.QueryDataClientJacksonModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Supplier;

public class JsonCodec<T> {
    static final Supplier<ObjectMapper> OBJECT_MAPPER_SUPPLIER = () -> {
        JsonFactory jsonFactory = JsonFactory.builder().streamReadConstraints(StreamReadConstraints.builder().maxStringLength(Integer.MAX_VALUE).maxNestingDepth(Integer.MAX_VALUE).maxNumberLength(Integer.MAX_VALUE).build()).build();
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder((JsonFactory)jsonFactory).enable(new StreamReadFeature[]{StreamReadFeature.USE_FAST_DOUBLE_PARSER})).enable(new StreamReadFeature[]{StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_CREATORS})).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_FIELDS})).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_SETTERS})).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_GETTERS})).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_IS_GETTERS})).disable(new MapperFeature[]{MapperFeature.USE_GETTERS_AS_SETTERS})).disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new MapperFeature[]{MapperFeature.INFER_PROPERTY_MUTATORS})).disable(new MapperFeature[]{MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS})).addModule((Module)new Jdk8Module())).addModule((Module)new QueryDataClientJacksonModule())).build();
    };
    private final ObjectMapper mapper;
    private final Type type;
    private final JavaType javaType;

    public static <T> JsonCodec<T> jsonCodec(Class<T> type) {
        return new JsonCodec<T>(OBJECT_MAPPER_SUPPLIER.get(), type);
    }

    private JsonCodec(ObjectMapper mapper, Type type) {
        this.mapper = Objects.requireNonNull(mapper, "mapper is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.javaType = mapper.getTypeFactory().constructType(type);
    }

    public Type getType() {
        return this.type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T fromJson(String json) throws JsonProcessingException {
        try (JsonParser parser = this.mapper.createParser(json);){
            Object value = this.mapper.readerFor(this.javaType).readValue(parser);
            Preconditions.checkArgument((parser.nextToken() == null ? 1 : 0) != 0, (Object)"Found characters after the expected end of input");
            Object object = value;
            return (T)object;
        }
        catch (JsonProcessingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public T fromJson(InputStream inputStream) throws IOException {
        try (JsonParser parser = this.mapper.createParser(inputStream);){
            Object value = this.mapper.readerFor(this.javaType).readValue(parser);
            Preconditions.checkArgument((parser.nextToken() == null ? 1 : 0) != 0, (Object)"Found characters after the expected end of input");
            Object object = value;
            return (T)object;
        }
    }

    public String toJson(T instance) {
        try {
            return this.mapper.writerFor(this.javaType).writeValueAsString(instance);
        }
        catch (IOException exception) {
            throw new IllegalArgumentException(String.format("%s could not be converted to JSON", instance.getClass().getName()), exception);
        }
    }
}

