/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.trino.client.QueryData;
import io.trino.client.RawQueryData;
import io.trino.client.spooling.EncodedQueryData;
import java.io.IOException;
import java.util.List;

public class QueryDataClientJacksonModule
extends SimpleModule {
    private static final TypeReference<Iterable<List<Object>>> DIRECT_FORMAT = new TypeReference<Iterable<List<Object>>>(){};
    private static final TypeReference<EncodedQueryData> ENCODED_FORMAT = new TypeReference<EncodedQueryData>(){};

    public QueryDataClientJacksonModule() {
        super(QueryDataClientJacksonModule.class.getSimpleName(), Version.unknownVersion());
        this.addDeserializer(QueryData.class, (JsonDeserializer)new Deserializer());
    }

    private static class Deserializer
    extends StdDeserializer<QueryData> {
        public Deserializer() {
            super(QueryData.class);
        }

        public QueryData deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.currentToken().equals((Object)JsonToken.START_ARRAY)) {
                return RawQueryData.of((Iterable)jsonParser.readValueAs(DIRECT_FORMAT));
            }
            return (QueryData)jsonParser.readValueAs(ENCODED_FORMAT);
        }
    }
}

