/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.spooling.encoding;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.Iterators;
import com.google.common.io.Closer;
import io.trino.client.spooling.encoding.JsonDecodingUtils;
import io.trino.client.spooling.encoding.QueryDataAccess;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

class JsonQueryDataAccess
implements QueryDataAccess {
    private static final JsonFactory JSON_FACTORY = JsonQueryDataAccess.createJsonFactory();
    private final InputStream stream;
    private final JsonDecodingUtils.TypeDecoder[] decoders;

    JsonQueryDataAccess(JsonDecodingUtils.TypeDecoder[] decoders, InputStream stream) {
        this.decoders = Objects.requireNonNull(decoders, "decoders is null");
        this.stream = Objects.requireNonNull(stream, "stream is null");
    }

    @Override
    public Iterable<List<Object>> toIterable() throws IOException {
        return new RowWiseIterator(this.stream, this.decoders);
    }

    @SuppressModernizer
    private static JsonFactory createJsonFactory() {
        return new JsonFactory().enable(JsonParser.Feature.USE_FAST_DOUBLE_PARSER).enable(JsonParser.Feature.USE_FAST_BIG_NUMBER_PARSER).disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
    }

    private static class RowWiseIterator
    implements Iterable<List<Object>>,
    Iterator<List<Object>> {
        private final Closer closer = Closer.create();
        private boolean closed;
        private final JsonParser parser;
        private final JsonDecodingUtils.TypeDecoder[] decoders;

        public RowWiseIterator(InputStream stream, JsonDecodingUtils.TypeDecoder[] decoders) throws IOException {
            Objects.requireNonNull(decoders, "decoders is null");
            Objects.requireNonNull(stream, "stream is null");
            this.parser = JSON_FACTORY.createParser(stream);
            this.decoders = decoders;
            this.closer.register((Closeable)this.parser);
            this.closer.register((Closeable)stream);
            Verify.verify((this.parser.nextToken() == JsonToken.START_ARRAY ? 1 : 0) != 0, (String)"Expected start of an array, but got %s", (Object)this.parser.currentToken());
            Verify.verify((this.parser.nextToken() == JsonToken.START_ARRAY ? 1 : 0) != 0, (String)"Expected start of the data array, but got %s", (Object)this.parser.currentToken());
        }

        private void checkIfClosed() {
            try {
                Verify.verify((this.parser.nextToken() == JsonToken.END_ARRAY ? 1 : 0) != 0, (String)"Expected end of data array, but got %s", (Object)this.parser.currentToken());
                switch (this.parser.nextToken()) {
                    case END_ARRAY: {
                        this.close();
                        break;
                    }
                    case START_ARRAY: {
                        break;
                    }
                    default: {
                        throw new VerifyException("Expected end of or start of next data array, but got " + this.parser.currentToken());
                    }
                }
            }
            catch (IOException e) {
                this.closed = true;
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.closed;
        }

        @Override
        public List<Object> next() {
            try {
                ArrayList<Object> row = new ArrayList<Object>(this.decoders.length);
                for (JsonDecodingUtils.TypeDecoder decoder : this.decoders) {
                    if (Objects.requireNonNull(this.parser.nextToken()) == JsonToken.VALUE_NULL) {
                        row.add(null);
                        continue;
                    }
                    row.add(decoder.decode(this.parser));
                }
                this.checkIfClosed();
                return Collections.unmodifiableList(row);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public Iterator<List<Object>> iterator() {
            return Iterators.unmodifiableIterator((Iterator)this);
        }

        private void close() throws IOException {
            this.closed = true;
            this.closer.close();
        }
    }
}

