/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.spooling;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.trino.client.spooling.DataAttributes;
import io.trino.client.spooling.Segment;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class SpooledSegment
extends Segment {
    private final URI dataUri;
    private final Map<String, List<String>> headers;
    private final URI ackUri;

    @JsonCreator
    public SpooledSegment(@JsonProperty(value="uri") URI dataUri, @JsonProperty(value="ackUri") URI ackUri, @JsonProperty(value="metadata") Map<String, Object> metadata, @JsonProperty(value="headers") Map<String, List<String>> headers) {
        this(dataUri, ackUri, new DataAttributes(metadata), headers);
    }

    SpooledSegment(URI dataUri, URI ackUri, DataAttributes metadata, Map<String, List<String>> headers) {
        super(metadata);
        this.dataUri = Objects.requireNonNull(dataUri, "dataUri is null");
        this.ackUri = Objects.requireNonNull(ackUri, "ackUri is null");
        this.headers = (Map)MoreObjects.firstNonNull(headers, (Object)ImmutableMap.of());
    }

    @JsonProperty(value="uri")
    public URI getDataUri() {
        return this.dataUri;
    }

    @JsonProperty(value="ackUri")
    public URI getAckUri() {
        return this.ackUri;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="headers")
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String toString() {
        return String.format("SpooledSegment{offset=%d, rows=%d, size=%d, headers=%s}", this.getOffset(), this.getRowsCount(), this.getSegmentSize(), this.headers.keySet());
    }
}

