/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.spooling.encoding;

import io.airlift.compress.lz4.Lz4Decompressor;
import io.trino.client.QueryDataDecoder;
import io.trino.client.spooling.encoding.CompressedQueryDataDecoder;
import java.io.IOException;

public class Lz4QueryDataDecoder
extends CompressedQueryDataDecoder {
    public Lz4QueryDataDecoder(QueryDataDecoder delegate) {
        super(delegate);
    }

    @Override
    void decompress(byte[] input, byte[] output) throws IOException {
        Lz4Decompressor decompressor = new Lz4Decompressor();
        int decompressedSize = decompressor.decompress(input, 0, input.length, output, 0, output.length);
        if (decompressedSize != output.length) {
            throw new IOException(String.format("Decompressed size does not match expected segment size, expected %d, got %d", decompressedSize, output.length));
        }
    }

    @Override
    public String encoding() {
        return this.delegate.encoding() + "+lz4";
    }
}

