/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.client.ClientTypeSignature;
import io.trino.client.RowFieldName;
import java.util.Objects;
import java.util.Optional;

public class NamedClientTypeSignature {
    private final Optional<RowFieldName> fieldName;
    private final ClientTypeSignature typeSignature;

    @JsonCreator
    public NamedClientTypeSignature(@JsonProperty(value="fieldName") Optional<RowFieldName> fieldName, @JsonProperty(value="typeSignature") ClientTypeSignature typeSignature) {
        this.fieldName = Objects.requireNonNull(fieldName, "fieldName is null");
        this.typeSignature = Objects.requireNonNull(typeSignature, "typeSignature is null");
    }

    @JsonProperty
    public Optional<RowFieldName> getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public ClientTypeSignature getTypeSignature() {
        return this.typeSignature;
    }

    public Optional<String> getName() {
        return this.getFieldName().map(RowFieldName::getName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedClientTypeSignature other = (NamedClientTypeSignature)o;
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.typeSignature, other.typeSignature);
    }

    public String toString() {
        return this.fieldName.map(rowFieldName -> String.valueOf(rowFieldName) + " " + String.valueOf(this.typeSignature)).orElseGet(this.typeSignature::toString);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.typeSignature);
    }
}

