/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.google.common.collect.ImmutableList;
import io.trino.client.RowField;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class Row {
    private final List<RowField> fields;

    private Row(List<RowField> fields) {
        this.fields = ImmutableList.copyOf((Collection)Objects.requireNonNull(fields, "fields is null"));
    }

    public List<RowField> getFields() {
        return this.fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Row row = (Row)o;
        return Objects.equals(this.fields, row.fields);
    }

    public int hashCode() {
        return Objects.hash(this.fields);
    }

    public String toString() {
        return this.fields.stream().map(field -> {
            if (field.getName().isPresent()) {
                return field.getName().get() + "=" + String.valueOf(field.getValue());
            }
            return String.valueOf(field.getValue());
        }).collect(Collectors.joining(", ", "{", "}"));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderWithExpectedSize(int fields) {
        return new Builder(fields);
    }

    public static final class Builder {
        private final ImmutableList.Builder<RowField> fields;
        private int size;

        private Builder() {
            this.fields = ImmutableList.builder();
        }

        private Builder(int fields) {
            this.fields = ImmutableList.builderWithExpectedSize((int)fields);
        }

        public Builder addField(String name, @Nullable Object value) {
            return this.addField(Optional.of(name), value);
        }

        public Builder addUnnamedField(@Nullable Object value) {
            return this.addField(Optional.empty(), value);
        }

        public Builder addField(Optional<String> name, @Nullable Object value) {
            Objects.requireNonNull(name, "name is null");
            this.fields.add((Object)new RowField(this.size++, name, value));
            return this;
        }

        public Row build() {
            return new Row((List<RowField>)this.fields.build());
        }
    }
}

