/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.auth.external;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import dev.failsafe.Failsafe;
import dev.failsafe.FailsafeException;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import io.trino.client.HttpStatusCodes;
import io.trino.client.JsonResponse;
import io.trino.client.TrinoJsonCodec;
import io.trino.client.auth.external.Token;
import io.trino.client.auth.external.TokenPollResult;
import io.trino.client.auth.external.TokenPoller;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class HttpTokenPoller
implements TokenPoller {
    private static final TrinoJsonCodec<TokenPollRepresentation> TOKEN_POLL_CODEC = TrinoJsonCodec.jsonCodec(TokenPollRepresentation.class);
    private static final String USER_AGENT_VALUE = "TrinoTokenPoller/" + (String)MoreObjects.firstNonNull((Object)HttpTokenPoller.class.getPackage().getImplementationVersion(), (Object)"unknown");
    private final Supplier<OkHttpClient> client;

    public HttpTokenPoller(OkHttpClient client) {
        Objects.requireNonNull(client, "client is null");
        this.client = () -> client;
    }

    public HttpTokenPoller(OkHttpClient client, Consumer<OkHttpClient.Builder> refreshableClientConfig) {
        Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(refreshableClientConfig, "refreshableClientConfig is null");
        this.client = () -> {
            OkHttpClient.Builder builder = client.newBuilder();
            refreshableClientConfig.accept(builder);
            return builder.build();
        };
    }

    @Override
    public TokenPollResult pollForToken(URI tokenUri, Duration timeout) {
        try {
            return (TokenPollResult)Failsafe.with((Policy)((RetryPolicyBuilder)RetryPolicy.builder().withMaxAttempts(-1).withMaxDuration(timeout).withBackoff(100L, 500L, ChronoUnit.MILLIS).handle(IOException.class)).build(), (Policy[])new RetryPolicy[0]).get(() -> this.executePoll(HttpTokenPoller.prepareRequestBuilder(tokenUri).build()));
        }
        catch (FailsafeException e) {
            if (e.getCause() instanceof IOException) {
                throw new UncheckedIOException((IOException)e.getCause());
            }
            throw e;
        }
    }

    @Override
    public void tokenReceived(URI tokenUri) {
        try {
            Failsafe.with((Policy)((RetryPolicyBuilder)RetryPolicy.builder().withMaxAttempts(-1).withMaxDuration(Duration.ofSeconds(4L)).withBackoff(100L, 500L, ChronoUnit.MILLIS).handleResultIf(code -> code >= 500)).build(), (Policy[])new RetryPolicy[0]).get(() -> {
                Request request = HttpTokenPoller.prepareRequestBuilder(tokenUri).delete().build();
                try (Response response = this.client.get().newCall(request).execute();){
                    Integer n = response.code();
                    return n;
                }
            });
        }
        catch (FailsafeException e) {
            if (e.getCause() instanceof IOException) {
                throw new UncheckedIOException((IOException)e.getCause());
            }
            throw e;
        }
    }

    private static Request.Builder prepareRequestBuilder(URI tokenUri) {
        HttpUrl url = HttpUrl.get((URI)tokenUri);
        if (url == null) {
            throw new IllegalArgumentException("Invalid token URI: " + String.valueOf(tokenUri));
        }
        return new Request.Builder().url(url).addHeader("User-Agent", USER_AGENT_VALUE);
    }

    private TokenPollResult executePoll(Request request) throws IOException {
        JsonResponse<TokenPollRepresentation> response = this.executeRequest(request);
        if (response.getStatusCode() == 200 && response.hasValue()) {
            return response.getValue().toResult();
        }
        String message = String.format("Request to %s failed: %s [Error: %s]", request.url(), response, response.getResponseBody().orElse("<Response Too Large>"));
        if (HttpStatusCodes.shouldRetry(response.getStatusCode())) {
            throw new IOException(message);
        }
        return TokenPollResult.failed(message);
    }

    private JsonResponse<TokenPollRepresentation> executeRequest(Request request) throws IOException {
        try {
            return JsonResponse.execute(TOKEN_POLL_CODEC, (Call.Factory)this.client.get(), request, OptionalLong.empty());
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public static class TokenPollRepresentation {
        private final String token;
        private final URI nextUri;
        private final String error;

        @JsonCreator
        public TokenPollRepresentation(@JsonProperty(value="token") String token, @JsonProperty(value="nextUri") URI nextUri, @JsonProperty(value="error") String error) {
            this.token = token;
            this.nextUri = nextUri;
            this.error = error;
        }

        TokenPollResult toResult() {
            if (this.token != null) {
                return TokenPollResult.successful(new Token(this.token));
            }
            if (this.error != null) {
                return TokenPollResult.failed(this.error);
            }
            if (this.nextUri != null) {
                return TokenPollResult.pending(this.nextUri);
            }
            return TokenPollResult.failed("Failed to poll for token. No fields set in response.");
        }
    }
}

