/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.spooling;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.io.Closer;
import io.trino.client.CloseableIterator;
import io.trino.client.QueryDataDecoder;
import io.trino.client.spooling.SegmentLoader;
import io.trino.client.spooling.SpooledSegment;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

class SpooledSegmentIterator
extends AbstractIterator<List<Object>>
implements CloseableIterator<List<Object>> {
    private final SpooledSegment segment;
    private final long rowsCount;
    private final SegmentLoader loader;
    private final QueryDataDecoder decoder;
    private long currentRow;
    private boolean loaded;
    private boolean closed;
    private Iterator<List<Object>> iterator;
    private Closer closer = Closer.create();

    public SpooledSegmentIterator(SpooledSegment spooledSegment, SegmentLoader loader, QueryDataDecoder decoder) {
        this.segment = Objects.requireNonNull(spooledSegment, "spooledSegment is null");
        this.rowsCount = spooledSegment.getRowsCount();
        this.loader = Objects.requireNonNull(loader, "loader is null");
        this.decoder = Objects.requireNonNull(decoder, "decoder is null");
        this.closer.register(() -> loader.acknowledge(this.segment));
    }

    public void load() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Iterator is already closed");
        Preconditions.checkState((!this.loaded ? 1 : 0) != 0, (Object)"Iterator is already loaded");
        Preconditions.checkState((this.iterator == null ? 1 : 0) != 0, (Object)"Iterator should be unloaded");
        try {
            InputStream stream = (InputStream)this.closer.register((Closeable)this.loader.load(this.segment));
            this.iterator = this.decoder.decode(stream, this.segment.getMetadata());
            this.loaded = true;
        }
        catch (IOException e) {
            this.closed = true;
            throw new UncheckedIOException(e);
        }
    }

    public void unload() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Iterator is already closed");
        this.closed = true;
        try {
            this.closer.close();
            this.iterator = null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public long remaining() {
        return this.rowsCount - this.currentRow;
    }

    protected List<Object> computeNext() {
        if (!this.loaded) {
            this.load();
        }
        if (++this.currentRow > this.rowsCount) {
            return (List)this.endOfData();
        }
        if (this.closed) {
            throw new NoSuchElementException();
        }
        try {
            Verify.verify((boolean)this.iterator.hasNext(), (String)"Iterator should have more rows, current: %s, count: %s", (long)this.currentRow, (long)this.rowsCount);
            List<Object> rows = this.iterator.next();
            if (this.currentRow == this.rowsCount) {
                this.unload();
            }
            return rows;
        }
        catch (Exception e) {
            this.unload();
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.unload();
        }
    }

    @Override
    public String toString() {
        return "SpooledSegmentIterator{segment=" + String.valueOf(this.segment) + "}";
    }
}

