/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.google.common.base.Verify;
import io.trino.client.CloseableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public interface ResultRows
extends Iterable<List<Object>>,
Closeable {
    public static final ResultRows NULL_ROWS = new ResultRows(){

        @Override
        public void close() {
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public Iterator<List<Object>> iterator() {
            return Collections.emptyIterator();
        }

        public String toString() {
            return "EmptyResultRows{}";
        }
    };

    public static ResultRows wrapIterator(final CloseableIterator<List<Object>> iterator) {
        return new ResultRows(){
            private volatile boolean fetched;

            @Override
            public void close() throws IOException {
                iterator.close();
            }

            @Override
            public Iterator<List<Object>> iterator() {
                Verify.verify((!this.fetched ? 1 : 0) != 0, (String)"Iterator already fetched", (Object[])new Object[0]);
                this.fetched = true;
                return iterator;
            }

            public String toString() {
                return "ResultRows{iterator=" + String.valueOf(iterator) + "}";
            }
        };
    }

    default public boolean isNull() {
        return false;
    }
}

