/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.spooling;

import com.google.common.collect.AbstractIterator;
import io.trino.client.CloseableIterator;
import io.trino.client.QueryDataDecoder;
import io.trino.client.spooling.InlineSegment;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;

class InlineSegmentIterator
extends AbstractIterator<List<Object>>
implements CloseableIterator<List<Object>> {
    private InlineSegment segment;
    private final QueryDataDecoder decoder;
    private CloseableIterator<List<Object>> iterator;

    public InlineSegmentIterator(InlineSegment segment, QueryDataDecoder decoder) {
        this.segment = Objects.requireNonNull(segment, "segment is null");
        this.decoder = Objects.requireNonNull(decoder, "decoder is null");
    }

    protected List<Object> computeNext() {
        if (this.iterator == null) {
            try {
                this.iterator = this.decoder.decode(new ByteArrayInputStream(this.segment.getData()), this.segment.getMetadata());
                this.segment = null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (this.iterator.hasNext()) {
            return (List)this.iterator.next();
        }
        return (List)this.endOfData();
    }

    @Override
    public void close() throws IOException {
        if (this.iterator != null) {
            this.iterator.close();
        }
    }
}

