/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.google.common.collect.ImmutableList;
import io.trino.client.QueryData;
import java.util.List;

public class TypedQueryData
implements QueryData {
    private final List<List<Object>> values;
    private final long rowsCount;

    private TypedQueryData(List<List<Object>> values, long rowsCount) {
        this.values = ImmutableList.copyOf(values);
        this.rowsCount = rowsCount;
    }

    public Iterable<List<Object>> getIterable() {
        return this.values;
    }

    public static QueryData of(List<List<Object>> values) {
        return new TypedQueryData(values, values != null ? (long)values.size() : 0L);
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public long getRowsCount() {
        return this.rowsCount;
    }
}

