/*
 * Decompiled with CFR 0.152.
 */
package io.trino.collect.cache;

import com.google.common.cache.LoadingCache;
import com.google.common.collect.ForwardingConcurrentMap;
import io.trino.collect.cache.NonEvictableLoadingCache;
import io.trino.collect.cache.NonKeyEvictableLoadingCacheImpl;
import java.util.concurrent.ConcurrentMap;

final class NonEvictableLoadingCacheImpl<K, V>
extends NonKeyEvictableLoadingCacheImpl<K, V>
implements NonEvictableLoadingCache<K, V> {
    NonEvictableLoadingCacheImpl(LoadingCache<K, V> delegate) {
        super(delegate);
    }

    @Override
    public void invalidateAll() {
        throw new UnsupportedOperationException("invalidateAll does not invalidate ongoing loads, so a stale value may remain in the cache for ever. Use EvictableCache if you need invalidation, or use SafeCaches.buildNonEvictableCacheWithWeakInvalidateAll() if invalidateAll is not required for correctness");
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        final ConcurrentMap map = super.asMap();
        return new ForwardingConcurrentMap<K, V>(){

            protected ConcurrentMap<K, V> delegate() {
                return map;
            }

            public void clear() {
                throw new UnsupportedOperationException("clear() does not invalidate ongoing loads, so a stale value may remain in the cache for ever. Use EvictableCacheBuilder if you need invalidation");
            }
        };
    }
}

