/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import io.trino.plugin.deltalake.DeltaLakeBucketFunction;
import io.trino.plugin.deltalake.DeltaLakePartitioningHandle;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import javax.inject.Inject;

public class DeltaLakeNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final TypeOperators typeOperators;
    private final NodeManager nodeManager;

    @Inject
    public DeltaLakeNodePartitioningProvider(TypeManager typeManager, NodeManager nodeManager) {
        this.typeOperators = Objects.requireNonNull(typeManager, "typeManager is null").getTypeOperators();
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public ConnectorBucketNodeMap getBucketNodeMap(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return ConnectorBucketNodeMap.createBucketNodeMap((int)this.nodeManager.getRequiredWorkerNodes().size());
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return split -> {
            throw new UnsupportedOperationException();
        };
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        DeltaLakePartitioningHandle handle = (DeltaLakePartitioningHandle)partitioningHandle;
        return new DeltaLakeBucketFunction(this.typeOperators, handle.getPartitioningColumns(), bucketCount);
    }
}

