/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore.glue;

import com.amazonaws.services.glue.model.Table;
import io.trino.plugin.deltalake.metastore.glue.DeltaLakeGlueMetastoreConfig;
import io.trino.plugin.hive.metastore.glue.DefaultGlueMetastoreTableFilterProvider;
import java.util.Objects;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Provider;

public class DeltaLakeGlueMetastoreTableFilterProvider
implements Provider<Predicate<Table>> {
    private final boolean hideNonDeltaLakeTables;

    @Inject
    public DeltaLakeGlueMetastoreTableFilterProvider(DeltaLakeGlueMetastoreConfig config) {
        Objects.requireNonNull(config, "config is null");
        this.hideNonDeltaLakeTables = config.isHideNonDeltaLakeTables();
    }

    public Predicate<Table> get() {
        if (this.hideNonDeltaLakeTables) {
            return DefaultGlueMetastoreTableFilterProvider::isDeltaLakeTable;
        }
        return table -> true;
    }
}

