/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class ParquetTypeVisitor<T> {
    protected LinkedList<String> fieldNames = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T visit(Type type, ParquetTypeVisitor<T> visitor) {
        if (type instanceof MessageType) {
            return visitor.message((MessageType)type, ParquetTypeVisitor.visitFields(type.asGroupType(), visitor));
        }
        if (type.isPrimitive()) {
            return visitor.primitive(type.asPrimitiveType());
        }
        GroupType group = type.asGroupType();
        OriginalType annotation = group.getOriginalType();
        if (annotation == OriginalType.LIST) {
            Preconditions.checkArgument((!group.isRepetition(Type.Repetition.REPEATED) ? 1 : 0) != 0, (Object)("Invalid list: top-level group is repeated: " + group));
            Preconditions.checkArgument((group.getFieldCount() == 1 ? 1 : 0) != 0, (Object)("Invalid list: does not contain single repeated field: " + group));
            GroupType repeatedElement = ((Type)group.getFields().get(0)).asGroupType();
            Preconditions.checkArgument((boolean)repeatedElement.isRepetition(Type.Repetition.REPEATED), (Object)"Invalid list: inner group is not repeated");
            Preconditions.checkArgument((repeatedElement.getFieldCount() <= 1 ? 1 : 0) != 0, (Object)("Invalid list: repeated group is not a single field: " + group));
            visitor.fieldNames.push(repeatedElement.getName());
            try {
                T elementResult = null;
                if (repeatedElement.getFieldCount() > 0) {
                    elementResult = ParquetTypeVisitor.visitField(repeatedElement.getType(0), visitor);
                }
                T t = visitor.list(group, elementResult);
                return t;
            }
            finally {
                visitor.fieldNames.pop();
            }
        }
        if (annotation == OriginalType.MAP) {
            Preconditions.checkArgument((!group.isRepetition(Type.Repetition.REPEATED) ? 1 : 0) != 0, (Object)("Invalid map: top-level group is repeated: " + group));
            Preconditions.checkArgument((group.getFieldCount() == 1 ? 1 : 0) != 0, (Object)("Invalid map: does not contain single repeated field: " + group));
            GroupType repeatedKeyValue = group.getType(0).asGroupType();
            Preconditions.checkArgument((boolean)repeatedKeyValue.isRepetition(Type.Repetition.REPEATED), (Object)"Invalid map: inner group is not repeated");
            Preconditions.checkArgument((repeatedKeyValue.getFieldCount() <= 2 ? 1 : 0) != 0, (Object)"Invalid map: repeated group does not have 2 fields");
            visitor.fieldNames.push(repeatedKeyValue.getName());
            try {
                T keyResult = null;
                T valueResult = null;
                if (repeatedKeyValue.getFieldCount() == 2) {
                    keyResult = ParquetTypeVisitor.visitField(repeatedKeyValue.getType(0), visitor);
                    valueResult = ParquetTypeVisitor.visitField(repeatedKeyValue.getType(1), visitor);
                } else if (repeatedKeyValue.getFieldCount() == 1) {
                    Type keyOrValue = repeatedKeyValue.getType(0);
                    if (keyOrValue.getName().equalsIgnoreCase("key")) {
                        keyResult = ParquetTypeVisitor.visitField(keyOrValue, visitor);
                    } else {
                        valueResult = ParquetTypeVisitor.visitField(keyOrValue, visitor);
                    }
                }
                T t = visitor.map(group, keyResult, valueResult);
                return t;
            }
            finally {
                visitor.fieldNames.pop();
            }
        }
        return visitor.struct(group, ParquetTypeVisitor.visitFields(group, visitor));
    }

    private static <T> T visitField(Type field, ParquetTypeVisitor<T> visitor) {
        visitor.fieldNames.push(field.getName());
        try {
            T t = ParquetTypeVisitor.visit(field, visitor);
            return t;
        }
        finally {
            visitor.fieldNames.pop();
        }
    }

    private static <T> List<T> visitFields(GroupType group, ParquetTypeVisitor<T> visitor) {
        ArrayList results = Lists.newArrayListWithExpectedSize((int)group.getFieldCount());
        for (Type field : group.getFields()) {
            results.add(ParquetTypeVisitor.visitField(field, visitor));
        }
        return results;
    }

    public T message(MessageType message, List<T> fields) {
        return null;
    }

    public T struct(GroupType struct, List<T> fields) {
        return null;
    }

    public T list(GroupType array, T element) {
        return null;
    }

    public T map(GroupType map, T key, T value) {
        return null;
    }

    public T primitive(PrimitiveType primitive) {
        return null;
    }
}

