/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.com.esri.core.geometry;

import com.linkedin.coral.com.esri.core.geometry.PeDouble;

final class GeoDist {
    private static final double PE_PI = Math.PI;
    private static final double PE_PI2 = 1.5707963267948966;
    private static final double PE_2PI = Math.PI * 2;
    private static final double PE_EPS = 3.552713678800501E-15;

    GeoDist() {
    }

    private static double PE_ABS(double a) {
        return a < 0.0 ? -a : a;
    }

    private static double PE_SGN(double a, double b) {
        return b >= 0.0 ? GeoDist.PE_ABS(a) : -GeoDist.PE_ABS(a);
    }

    private static boolean PE_EQ(double a, double b) {
        return a == b || GeoDist.PE_ABS(a - b) <= 3.552713678800501E-15 * (1.0 + (GeoDist.PE_ABS(a) + GeoDist.PE_ABS(b)) / 2.0);
    }

    private static boolean PE_ZERO(double a) {
        return a == 0.0 || GeoDist.PE_ABS(a) <= 3.552713678800501E-15;
    }

    private static double lam_delta(double lam) {
        double d = Math.IEEEremainder(lam, Math.PI * 2);
        return GeoDist.PE_ABS(d) <= Math.PI ? d : (d < 0.0 ? d + Math.PI * 2 : d - Math.PI * 2);
    }

    private static void lam_phi_reduction(PeDouble p_lam, PeDouble p_phi) {
        p_lam.val = GeoDist.lam_delta(p_lam.val);
        p_phi.val = GeoDist.lam_delta(p_phi.val);
        if (GeoDist.PE_ABS(p_phi.val) > 1.5707963267948966) {
            p_lam.val = GeoDist.lam_delta(p_lam.val + Math.PI);
            p_phi.val = GeoDist.PE_SGN(Math.PI, p_phi.val) - p_phi.val;
        }
    }

    private static double q90(double a, double e2) {
        double t = Math.sqrt(1.0 - e2);
        double n = (1.0 - t) / (1.0 + t);
        double n2 = n * n;
        return a / (1.0 + n) * (1.0 + n2 * (0.25 + n2 * (0.015625 + n2 * 0.00390625))) * 1.5707963267948966;
    }

    public static void geodesic_distance_ngs(double a, double e2, double lam1, double phi1, double lam2, double phi2, PeDouble p_dist, PeDouble p_az12, PeDouble p_az21) {
        double tol = 1.0E-14;
        double eps = 1.0E-15;
        double boa = 0.0;
        double dlam = 0.0;
        double eta1 = 0.0;
        double sin_eta1 = 0.0;
        double cos_eta1 = 0.0;
        double eta2 = 0.0;
        double sin_eta2 = 0.0;
        double cos_eta2 = 0.0;
        double prev = 0.0;
        double test = 0.0;
        double sin_lam_sph = 0.0;
        double cos_lam_sph = 0.0;
        double temp = 0.0;
        double sin_sigma = 0.0;
        double cos_sigma = 0.0;
        double sin_azeq = 0.0;
        double cos2_azeq = 0.0;
        double costm = 0.0;
        double costm2 = 0.0;
        double c = 0.0;
        double d = 0.0;
        double tem1 = 0.0;
        double tem2 = 0.0;
        double ep2 = 0.0;
        double bige = 0.0;
        double bigf = 0.0;
        double biga = 0.0;
        double bigb = 0.0;
        double z = 0.0;
        double dsigma = 0.0;
        double f = 0.0;
        double az12 = 0.0;
        double az21 = 0.0;
        double dist = 0.0;
        double sigma = 0.0;
        double lam_sph = 0.0;
        int it = 0;
        int kind = 0;
        PeDouble lam = new PeDouble();
        PeDouble phi = new PeDouble();
        if (p_dist == null && p_az12 == null && p_az21 == null) {
            return;
        }
        lam.val = lam1;
        phi.val = phi1;
        GeoDist.lam_phi_reduction(lam, phi);
        lam1 = lam.val;
        phi1 = phi.val;
        lam.val = lam2;
        phi.val = phi2;
        GeoDist.lam_phi_reduction(lam, phi);
        lam2 = lam.val;
        phi2 = phi.val;
        dlam = GeoDist.lam_delta(lam2 - lam1);
        if (GeoDist.PE_EQ(phi1, phi2) && (GeoDist.PE_ZERO(dlam) || GeoDist.PE_EQ(GeoDist.PE_ABS(phi1), 1.5707963267948966))) {
            if (p_dist != null) {
                p_dist.val = 0.0;
            }
            if (p_az12 != null) {
                p_az12.val = 0.0;
            }
            if (p_az21 != null) {
                p_az21.val = 0.0;
            }
            return;
        }
        if (GeoDist.PE_EQ(phi1, -phi2)) {
            if (GeoDist.PE_EQ(GeoDist.PE_ABS(phi1), 1.5707963267948966)) {
                if (p_dist != null) {
                    p_dist.val = 2.0 * GeoDist.q90(a, e2);
                }
                if (p_az12 != null) {
                    double d2 = p_az12.val = phi1 > 0.0 ? GeoDist.lam_delta(Math.PI - GeoDist.lam_delta(lam2)) : GeoDist.lam_delta(lam2);
                }
                if (p_az21 != null) {
                    p_az21.val = phi1 > 0.0 ? GeoDist.lam_delta(lam2) : GeoDist.lam_delta(Math.PI - GeoDist.lam_delta(lam2));
                }
                return;
            }
            if (GeoDist.PE_EQ(GeoDist.PE_ABS(dlam), Math.PI)) {
                if (p_dist != null) {
                    p_dist.val = 2.0 * GeoDist.q90(a, e2);
                }
                if (p_az12 != null) {
                    p_az12.val = 0.0;
                }
                if (p_az21 != null) {
                    p_az21.val = 0.0;
                }
                return;
            }
        }
        if (GeoDist.PE_ZERO(e2)) {
            double cos_phi1 = Math.cos(phi1);
            double cos_phi2 = Math.cos(phi2);
            double sin_phi1 = Math.sin(phi1);
            double sin_phi2 = Math.sin(phi2);
            if (p_dist != null) {
                tem1 = Math.sin((phi2 - phi1) / 2.0);
                tem2 = Math.sin(dlam / 2.0);
                sigma = 2.0 * Math.asin(Math.sqrt(tem1 * tem1 + cos_phi1 * cos_phi2 * tem2 * tem2));
                p_dist.val = sigma * a;
            }
            if (p_az12 != null) {
                p_az12.val = GeoDist.PE_EQ(GeoDist.PE_ABS(phi1), 1.5707963267948966) ? (phi1 < 0.0 ? lam2 : GeoDist.lam_delta(Math.PI - lam2)) : Math.atan2(cos_phi2 * Math.sin(dlam), cos_phi1 * sin_phi2 - sin_phi1 * cos_phi2 * Math.cos(dlam));
            }
            if (p_az21 != null) {
                if (GeoDist.PE_EQ(GeoDist.PE_ABS(phi2), 1.5707963267948966)) {
                    p_az21.val = phi2 < 0.0 ? lam1 : GeoDist.lam_delta(Math.PI - lam1);
                } else {
                    p_az21.val = Math.atan2(cos_phi1 * Math.sin(dlam), sin_phi2 * cos_phi1 * Math.cos(dlam) - cos_phi2 * sin_phi1);
                    p_az21.val = GeoDist.lam_delta(p_az21.val + Math.PI);
                }
            }
            return;
        }
        f = 1.0 - Math.sqrt(1.0 - e2);
        boa = 1.0 - f;
        eta1 = Math.atan(boa * Math.tan(phi1));
        sin_eta1 = Math.sin(eta1);
        cos_eta1 = Math.cos(eta1);
        eta2 = Math.atan(boa * Math.tan(phi2));
        sin_eta2 = Math.sin(eta2);
        cos_eta2 = Math.cos(eta2);
        prev = dlam;
        test = dlam;
        it = 0;
        kind = 1;
        lam_sph = dlam;
        boolean q_continue_looping = true;
        while (q_continue_looping && it < 100) {
            ++it;
            if (kind == 1) {
                sin_lam_sph = Math.sin(lam_sph);
                cos_lam_sph = Math.cos(lam_sph);
                tem1 = cos_eta2 * sin_lam_sph;
                temp = cos_eta1 * sin_eta2 - sin_eta1 * cos_eta2 * cos_lam_sph;
                sin_sigma = Math.sqrt(tem1 * tem1 + temp * temp);
                cos_sigma = sin_eta1 * sin_eta2 + cos_eta1 * cos_eta2 * cos_lam_sph;
                sigma = Math.atan2(sin_sigma, cos_sigma);
                sin_azeq = GeoDist.PE_ABS(sin_sigma) < eps ? cos_eta1 * cos_eta2 * sin_lam_sph / GeoDist.PE_SGN(eps, sin_sigma) : cos_eta1 * cos_eta2 * sin_lam_sph / sin_sigma;
                cos2_azeq = 1.0 - sin_azeq * sin_azeq;
                costm = GeoDist.PE_ABS(cos2_azeq) < eps ? cos_sigma - 2.0 * (sin_eta1 * sin_eta2 / GeoDist.PE_SGN(eps, cos2_azeq)) : cos_sigma - 2.0 * (sin_eta1 * sin_eta2 / cos2_azeq);
                costm2 = costm * costm;
                c = ((-3.0 * cos2_azeq + 4.0) * f + 4.0) * cos2_azeq * f / 16.0;
            }
            d = (1.0 - c) * f * (sigma + c * sin_sigma * (costm + cos_sigma * c * (2.0 * costm2 - 1.0)));
            if (kind == 1) {
                lam_sph = dlam + d * sin_azeq;
                if (GeoDist.PE_ABS(lam_sph - test) < tol) {
                    q_continue_looping = false;
                    continue;
                }
                if (GeoDist.PE_ABS(lam_sph) > Math.PI) {
                    kind = 2;
                    lam_sph = Math.PI;
                    if (dlam < 0.0) {
                        lam_sph = -lam_sph;
                    }
                    sin_azeq = 0.0;
                    cos2_azeq = 1.0;
                    prev = test = 2.0;
                    sigma = Math.PI - GeoDist.PE_ABS(Math.atan(sin_eta1 / cos_eta1) + Math.atan(sin_eta2 / cos_eta2));
                    sin_sigma = Math.sin(sigma);
                    cos_sigma = Math.cos(sigma);
                    c = ((-3.0 * cos2_azeq + 4.0) * f + 4.0) * cos2_azeq * f / 16.0;
                    if (GeoDist.PE_ABS(sin_azeq - prev) < tol) {
                        q_continue_looping = false;
                        continue;
                    }
                    costm = GeoDist.PE_ABS(cos2_azeq) < eps ? cos_sigma - 2.0 * (sin_eta1 * sin_eta2 / GeoDist.PE_SGN(eps, cos2_azeq)) : cos_sigma - 2.0 * (sin_eta1 * sin_eta2 / cos2_azeq);
                    costm2 = costm * costm;
                    continue;
                }
                if ((lam_sph - test) * (test - prev) < 0.0 && it > 5) {
                    lam_sph = (2.0 * lam_sph + 3.0 * test + prev) / 6.0;
                }
                prev = test;
                test = lam_sph;
                continue;
            }
            sin_azeq = (lam_sph - dlam) / d;
            if ((sin_azeq - test) * (test - prev) < 0.0 && it > 5) {
                sin_azeq = (2.0 * sin_azeq + 3.0 * test + prev) / 6.0;
            }
            prev = test;
            test = sin_azeq;
            cos2_azeq = 1.0 - sin_azeq * sin_azeq;
            sin_lam_sph = sin_azeq * sin_sigma / (cos_eta1 * cos_eta2);
            cos_lam_sph = -Math.sqrt(GeoDist.PE_ABS(1.0 - sin_lam_sph * sin_lam_sph));
            lam_sph = Math.atan2(sin_lam_sph, cos_lam_sph);
            tem1 = cos_eta2 * sin_lam_sph;
            temp = cos_eta1 * sin_eta2 - sin_eta1 * cos_eta2 * cos_lam_sph;
            sin_sigma = Math.sqrt(tem1 * tem1 + temp * temp);
            cos_sigma = sin_eta1 * sin_eta2 + cos_eta1 * cos_eta2 * cos_lam_sph;
            sigma = Math.atan2(sin_sigma, cos_sigma);
            c = ((-3.0 * cos2_azeq + 4.0) * f + 4.0) * cos2_azeq * f / 16.0;
            if (GeoDist.PE_ABS(sin_azeq - prev) < tol) {
                q_continue_looping = false;
                continue;
            }
            costm = GeoDist.PE_ABS(cos2_azeq) < eps ? cos_sigma - 2.0 * (sin_eta1 * sin_eta2 / GeoDist.PE_SGN(eps, cos2_azeq)) : cos_sigma - 2.0 * (sin_eta1 * sin_eta2 / cos2_azeq);
            costm2 = costm * costm;
        }
        if (p_dist != null) {
            ep2 = 1.0 / (boa * boa) - 1.0;
            bige = Math.sqrt(1.0 + ep2 * cos2_azeq);
            bigf = (bige - 1.0) / (bige + 1.0);
            biga = (1.0 + bigf * bigf / 4.0) / (1.0 - bigf);
            bigb = bigf * (1.0 - 0.375 * bigf * bigf);
            z = bigb / 6.0 * costm * (-3.0 + 4.0 * sin_sigma * sin_sigma) * (-3.0 + 4.0 * costm2);
            dsigma = bigb * sin_sigma * (costm + bigb / 4.0 * (cos_sigma * (-1.0 + 2.0 * costm2) - z));
            p_dist.val = dist = boa * a * biga * (sigma - dsigma);
        }
        if (p_az12 != null || p_az21 != null) {
            if (kind == 2) {
                az12 = sin_azeq / cos_eta1;
                az21 = Math.sqrt(1.0 - az12 * az12);
                if (temp < 0.0) {
                    az21 = -az21;
                }
                az12 = Math.atan2(az12, az21);
                tem1 = -sin_azeq;
                tem2 = sin_eta1 * sin_sigma - cos_eta1 * cos_sigma * az21;
                az21 = Math.atan2(tem1, tem2);
            } else {
                tem1 = cos_eta2 * sin_lam_sph;
                tem2 = cos_eta1 * sin_eta2 - sin_eta1 * cos_eta2 * cos_lam_sph;
                az12 = Math.atan2(tem1, tem2);
                tem1 = -cos_eta1 * sin_lam_sph;
                tem2 = sin_eta1 * cos_eta2 - cos_eta1 * sin_eta2 * cos_lam_sph;
                az21 = Math.atan2(tem1, tem2);
            }
            if (p_az12 != null) {
                p_az12.val = GeoDist.lam_delta(az12);
            }
            if (p_az21 != null) {
                p_az21.val = GeoDist.lam_delta(az21);
            }
        }
    }
}

