/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.com.esri.core.geometry;

import com.linkedin.coral.com.esri.core.geometry.AttributeStreamOfDbl;
import com.linkedin.coral.com.esri.core.geometry.Envelope;
import com.linkedin.coral.com.esri.core.geometry.Envelope1D;
import com.linkedin.coral.com.esri.core.geometry.Envelope2D;
import com.linkedin.coral.com.esri.core.geometry.Envelope2DIntersectorImpl;
import com.linkedin.coral.com.esri.core.geometry.Geometry;
import com.linkedin.coral.com.esri.core.geometry.GeometryException;
import com.linkedin.coral.com.esri.core.geometry.Line;
import com.linkedin.coral.com.esri.core.geometry.MultiPath;
import com.linkedin.coral.com.esri.core.geometry.MultiPathImpl;
import com.linkedin.coral.com.esri.core.geometry.MultiPoint;
import com.linkedin.coral.com.esri.core.geometry.MultiPointImpl;
import com.linkedin.coral.com.esri.core.geometry.MultiVertexGeometry;
import com.linkedin.coral.com.esri.core.geometry.MultiVertexGeometryImpl;
import com.linkedin.coral.com.esri.core.geometry.Point;
import com.linkedin.coral.com.esri.core.geometry.Point2D;
import com.linkedin.coral.com.esri.core.geometry.Polygon;
import com.linkedin.coral.com.esri.core.geometry.Polyline;
import com.linkedin.coral.com.esri.core.geometry.QuadTree;
import com.linkedin.coral.com.esri.core.geometry.QuadTreeImpl;
import com.linkedin.coral.com.esri.core.geometry.Segment;
import com.linkedin.coral.com.esri.core.geometry.SegmentIteratorImpl;
import com.linkedin.coral.com.esri.core.geometry.SpatialReference;
import com.linkedin.coral.com.esri.core.geometry.VertexDescription;
import com.linkedin.coral.com.esri.core.geometry.VertexDescriptionDesignerImpl;

final class InternalUtils {
    InternalUtils() {
    }

    static int addPointsToArray(Point2D p0In, Point2D p1In, Point2D[] pointsArray, int idx, Envelope2D fullRange2D, boolean clockwise, double densifyDist) {
        Point2D p0 = new Point2D();
        p0.setCoords(p0In);
        Point2D p1 = new Point2D();
        p1.setCoords(p1In);
        fullRange2D._snapToBoundary(p0);
        fullRange2D._snapToBoundary(p1);
        double boundDist0 = fullRange2D._boundaryDistance(p0);
        double boundDist1 = fullRange2D._boundaryDistance(p1);
        if (boundDist1 == 0.0) {
            boundDist1 = fullRange2D.getLength();
        }
        if ((p0.x == p1.x || p0.y == p1.y && (p0.y == fullRange2D.ymin || p0.y == fullRange2D.ymax)) && boundDist1 > boundDist0 == clockwise) {
            long cPoints;
            Point2D delta = new Point2D();
            delta.setCoords(p1.x - p0.x, p1.y - p0.y);
            if (densifyDist != 0.0 && (cPoints = (long)(delta._norm(0) / densifyDist)) > 0L) {
                delta.scale(1.0 / (double)(cPoints + 1L));
                for (long i = 0L; i < cPoints; ++i) {
                    p0.add(delta);
                    pointsArray[idx++].setCoords(p0.x, p0.y);
                }
            }
        } else {
            int side0 = fullRange2D._envelopeSide(p0);
            int side1 = fullRange2D._envelopeSide(p1);
            int deltaSide = clockwise ? 1 : 3;
            do {
                side0 = side0 + deltaSide & 3;
                Point2D corner = fullRange2D.queryCorner(side0);
                if (densifyDist != 0.0) {
                    idx = InternalUtils.addPointsToArray(p0, corner, pointsArray, idx, fullRange2D, clockwise, densifyDist);
                }
                pointsArray[idx++].setCoords(corner.x, corner.y);
                p0 = corner;
            } while ((side0 & 3) != side1);
            if (densifyDist != 0.0) {
                idx = InternalUtils.addPointsToArray(p0, p1, pointsArray, idx, fullRange2D, clockwise, densifyDist);
            }
        }
        return idx;
    }

    void shiftPath(MultiPath inputGeom, int iPath, double shift) {
        MultiVertexGeometryImpl vertexGeometryImpl = (MultiVertexGeometryImpl)inputGeom._getImpl();
        AttributeStreamOfDbl xyStream = (AttributeStreamOfDbl)vertexGeometryImpl.getAttributeStreamRef(0);
        int i2 = inputGeom.getPathEnd(iPath);
        Point2D pt = new Point2D();
        for (int i1 = inputGeom.getPathStart(iPath); i1 < i2; ++i1) {
            xyStream.read(i1, pt);
            pt.x += shift;
            xyStream.write(i1, pt);
        }
    }

    static double calculateToleranceFromGeometry(SpatialReference sr, Envelope2D env2D, boolean bConservative) {
        double stolerance;
        double gtolerance = env2D._calculateToleranceFromEnvelope();
        double d = stolerance = sr != null ? sr.getTolerance(0) : 0.0;
        if (bConservative) {
            gtolerance *= 4.0;
            stolerance *= 1.1;
        }
        return Math.max(stolerance, gtolerance);
    }

    static double adjust_tolerance_for_TE_clustering(double tol) {
        return 2.0 * Math.sqrt(2.0) * tol;
    }

    static double adjust_tolerance_for_TE_cracking(double tol) {
        return Math.sqrt(2.0) * tol;
    }

    static double calculateToleranceFromGeometry(SpatialReference sr, Geometry geometry, boolean bConservative) {
        Envelope2D env2D = new Envelope2D();
        geometry.queryEnvelope2D(env2D);
        return InternalUtils.calculateToleranceFromGeometry(sr, env2D, bConservative);
    }

    static double calculateZToleranceFromGeometry(SpatialReference sr, Geometry geometry, boolean bConservative) {
        double stolerance;
        Envelope1D env1D = geometry.queryInterval(1, 0);
        double gtolerance = env1D._calculateToleranceFromEnvelope();
        double d = stolerance = sr != null ? sr.getTolerance(1) : 0.0;
        if (bConservative) {
            gtolerance *= 4.0;
            stolerance *= 1.1;
        }
        return Math.max(stolerance, gtolerance);
    }

    double calculateZToleranceFromGeometry(SpatialReference sr, Geometry geometry) {
        Envelope1D env1D = geometry.queryInterval(1, 0);
        double tolerance = env1D._calculateToleranceFromEnvelope();
        return Math.max(sr != null ? sr.getTolerance(1) : 0.0, tolerance);
    }

    public static Envelope2D getMergedExtent(Geometry geom1, Envelope2D env2) {
        Envelope2D env1 = new Envelope2D();
        geom1.queryLooseEnvelope2D(env1);
        env1.merge(env2);
        return env1;
    }

    public static Envelope2D getMergedExtent(Geometry geom1, Geometry geom2) {
        Envelope2D env1 = new Envelope2D();
        geom1.queryLooseEnvelope2D(env1);
        Envelope2D env2 = new Envelope2D();
        geom2.queryLooseEnvelope2D(env2);
        env1.merge(env2);
        return env1;
    }

    public static Geometry createGeometry(int gt, VertexDescription vdIn) {
        VertexDescription vd = vdIn;
        if (vd == null) {
            vd = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        }
        switch (gt) {
            case 33: {
                return new Point(vd);
            }
            case 322: {
                return new Line(vd);
            }
            case 197: {
                return new Envelope(vd);
            }
            case 550: {
                return new MultiPoint(vd);
            }
            case 1607: {
                return new Polyline(vd);
            }
            case 1736: {
                return new Polygon(vd);
            }
        }
        throw new GeometryException("invalid argument.");
    }

    static boolean isClockwiseRing(MultiPathImpl polygon, int iring) {
        Point2D r;
        Point2D p;
        int high_point_index = polygon.getHighestPointIndex(iring);
        int path_start = polygon.getPathStart(iring);
        int path_end = polygon.getPathEnd(iring);
        Point2D q = polygon.getXY(high_point_index);
        if (high_point_index == path_start) {
            p = polygon.getXY(path_end - 1);
            r = polygon.getXY(path_start + 1);
        } else if (high_point_index == path_end - 1) {
            p = polygon.getXY(high_point_index - 1);
            r = polygon.getXY(path_start);
        } else {
            p = polygon.getXY(high_point_index - 1);
            r = polygon.getXY(high_point_index + 1);
        }
        int orientation = Point2D.orientationRobust(p, q, r);
        if (orientation == 0) {
            return polygon.calculateRingArea2D(iring) > 0.0;
        }
        return orientation == -1;
    }

    static QuadTreeImpl buildQuadTree(MultiPathImpl multipathImpl) {
        Envelope2D extent = new Envelope2D();
        multipathImpl.queryLooseEnvelope2D(extent);
        QuadTreeImpl quad_tree_impl = new QuadTreeImpl(extent, 8);
        int hint_index = -1;
        SegmentIteratorImpl seg_iter = multipathImpl.querySegmentIterator();
        Envelope2D boundingbox = new Envelope2D();
        boolean resized_extent = false;
        block0: while (seg_iter.nextPath()) {
            while (seg_iter.hasNextSegment()) {
                Segment segment = seg_iter.nextSegment();
                int index = seg_iter.getStartPointIndex();
                segment.queryEnvelope2D(boundingbox);
                if ((hint_index = quad_tree_impl.insert(index, boundingbox, hint_index)) != -1) continue;
                if (resized_extent) {
                    throw GeometryException.GeometryInternalError();
                }
                multipathImpl.calculateEnvelope2D(extent, false);
                resized_extent = true;
                quad_tree_impl.reset(extent, 8);
                seg_iter.resetToFirstPath();
                continue block0;
            }
        }
        return quad_tree_impl;
    }

    static QuadTreeImpl buildQuadTree(MultiPathImpl multipathImpl, Envelope2D extentOfInterest) {
        Envelope2D extent = new Envelope2D();
        multipathImpl.queryLooseEnvelope2D(extent);
        QuadTreeImpl quad_tree_impl = new QuadTreeImpl(extent, 8);
        int hint_index = -1;
        Envelope2D boundingbox = new Envelope2D();
        SegmentIteratorImpl seg_iter = multipathImpl.querySegmentIterator();
        boolean resized_extent = false;
        block0: while (seg_iter.nextPath()) {
            while (seg_iter.hasNextSegment()) {
                Segment segment = seg_iter.nextSegment();
                int index = seg_iter.getStartPointIndex();
                segment.queryEnvelope2D(boundingbox);
                if (!boundingbox.isIntersecting(extentOfInterest) || (hint_index = quad_tree_impl.insert(index, boundingbox, hint_index)) != -1) continue;
                if (resized_extent) {
                    throw GeometryException.GeometryInternalError();
                }
                multipathImpl.calculateEnvelope2D(extent, false);
                resized_extent = true;
                quad_tree_impl.reset(extent, 8);
                seg_iter.resetToFirstPath();
                continue block0;
            }
        }
        return quad_tree_impl;
    }

    static QuadTreeImpl buildQuadTreeForPaths(MultiPathImpl multipathImpl) {
        Envelope2D extent = new Envelope2D();
        multipathImpl.queryLooseEnvelope2D(extent);
        if (extent.isEmpty()) {
            return null;
        }
        QuadTreeImpl quad_tree_impl = new QuadTreeImpl(extent, 8);
        int hint_index = -1;
        Envelope2D boundingbox = new Envelope2D();
        boolean resized_extent = false;
        block0: do {
            int npaths = multipathImpl.getPathCount();
            for (int ipath = 0; ipath < npaths; ++ipath) {
                multipathImpl.queryPathEnvelope2D(ipath, boundingbox);
                hint_index = quad_tree_impl.insert(ipath, boundingbox, hint_index);
                if (hint_index == -1) {
                    if (resized_extent) {
                        throw GeometryException.GeometryInternalError();
                    }
                    multipathImpl.calculateEnvelope2D(extent, false);
                    resized_extent = true;
                    quad_tree_impl.reset(extent, 8);
                    continue block0;
                }
                resized_extent = false;
            }
        } while (resized_extent);
        return quad_tree_impl;
    }

    static QuadTreeImpl buildQuadTree(MultiPointImpl multipointImpl) {
        Envelope2D extent = new Envelope2D();
        multipointImpl.queryLooseEnvelope2D(extent);
        QuadTreeImpl quad_tree_impl = new QuadTreeImpl(extent, 8);
        Point2D pt = new Point2D();
        Envelope2D boundingbox = new Envelope2D();
        boolean resized_extent = false;
        for (int i = 0; i < multipointImpl.getPointCount(); ++i) {
            multipointImpl.getXY(i, pt);
            boundingbox.setCoords(pt);
            int element_handle = quad_tree_impl.insert(i, boundingbox);
            if (element_handle != -1) continue;
            if (resized_extent) {
                throw GeometryException.GeometryInternalError();
            }
            multipointImpl.calculateEnvelope2D(extent, false);
            resized_extent = true;
            quad_tree_impl.reset(extent, 8);
            i = -1;
        }
        return quad_tree_impl;
    }

    static QuadTreeImpl buildQuadTree(MultiPointImpl multipointImpl, Envelope2D extentOfInterest) {
        QuadTreeImpl quad_tree_impl = new QuadTreeImpl(extentOfInterest, 8);
        Point2D pt = new Point2D();
        boolean resized_extent = false;
        Envelope2D boundingbox = new Envelope2D();
        for (int i = 0; i < multipointImpl.getPointCount(); ++i) {
            multipointImpl.getXY(i, pt);
            if (!extentOfInterest.contains(pt)) continue;
            boundingbox.setCoords(pt);
            int element_handle = quad_tree_impl.insert(i, boundingbox);
            if (element_handle != -1) continue;
            if (resized_extent) {
                throw GeometryException.GeometryInternalError();
            }
            resized_extent = true;
            Envelope2D extent = new Envelope2D();
            multipointImpl.calculateEnvelope2D(extent, false);
            quad_tree_impl.reset(extent, 8);
            i = -1;
        }
        return quad_tree_impl;
    }

    static Envelope2DIntersectorImpl getEnvelope2DIntersector(MultiPathImpl multipathImplA, MultiPathImpl multipathImplB, double tolerance) {
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        multipathImplA.queryLooseEnvelope2D(env_a);
        multipathImplB.queryLooseEnvelope2D(env_b);
        env_a.inflate(tolerance, tolerance);
        env_b.inflate(tolerance, tolerance);
        Envelope2D envInter = new Envelope2D();
        envInter.setCoords(env_a);
        envInter.intersect(env_b);
        SegmentIteratorImpl segIterA = multipathImplA.querySegmentIterator();
        SegmentIteratorImpl segIterB = multipathImplB.querySegmentIterator();
        Envelope2DIntersectorImpl intersector = new Envelope2DIntersectorImpl();
        intersector.setTolerance(tolerance);
        boolean b_found_red = false;
        intersector.startRedConstruction();
        while (segIterA.nextPath()) {
            while (segIterA.hasNextSegment()) {
                Segment segmentA = segIterA.nextSegment();
                segmentA.queryEnvelope2D(env_a);
                if (!env_a.isIntersecting(envInter)) continue;
                b_found_red = true;
                Envelope2D env = new Envelope2D();
                env.setCoords(env_a);
                intersector.addRedEnvelope(segIterA.getStartPointIndex(), env);
            }
        }
        intersector.endRedConstruction();
        if (!b_found_red) {
            return null;
        }
        boolean b_found_blue = false;
        intersector.startBlueConstruction();
        while (segIterB.nextPath()) {
            while (segIterB.hasNextSegment()) {
                Segment segmentB = segIterB.nextSegment();
                segmentB.queryEnvelope2D(env_b);
                if (!env_b.isIntersecting(envInter)) continue;
                b_found_blue = true;
                Envelope2D env = new Envelope2D();
                env.setCoords(env_b);
                intersector.addBlueEnvelope(segIterB.getStartPointIndex(), env);
            }
        }
        intersector.endBlueConstruction();
        if (!b_found_blue) {
            return null;
        }
        return intersector;
    }

    static Envelope2DIntersectorImpl getEnvelope2DIntersectorForParts(MultiPathImpl multipathImplA, MultiPathImpl multipathImplB, double tolerance, boolean bExteriorOnlyA, boolean bExteriorOnlyB) {
        int type_a = multipathImplA.getType().value();
        int type_b = multipathImplB.getType().value();
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        multipathImplA.queryLooseEnvelope2D(env_a);
        multipathImplB.queryLooseEnvelope2D(env_b);
        env_a.inflate(tolerance, tolerance);
        env_b.inflate(tolerance, tolerance);
        Envelope2D envInter = new Envelope2D();
        envInter.setCoords(env_a);
        envInter.intersect(env_b);
        Envelope2DIntersectorImpl intersector = new Envelope2DIntersectorImpl();
        intersector.setTolerance(tolerance);
        boolean b_found_red = false;
        intersector.startRedConstruction();
        int npaths = multipathImplA.getPathCount();
        for (int ipath_a = 0; ipath_a < npaths; ++ipath_a) {
            if (bExteriorOnlyA && type_a == 1736 && !multipathImplA.isExteriorRing(ipath_a)) continue;
            multipathImplA.queryPathEnvelope2D(ipath_a, env_a);
            if (!env_a.isIntersecting(envInter)) continue;
            b_found_red = true;
            intersector.addRedEnvelope(ipath_a, env_a);
        }
        intersector.endRedConstruction();
        if (!b_found_red) {
            return null;
        }
        boolean b_found_blue = false;
        intersector.startBlueConstruction();
        int npaths2 = multipathImplB.getPathCount();
        for (int ipath_b = 0; ipath_b < npaths2; ++ipath_b) {
            if (bExteriorOnlyB && type_b == 1736 && !multipathImplB.isExteriorRing(ipath_b)) continue;
            multipathImplB.queryPathEnvelope2D(ipath_b, env_b);
            if (!env_b.isIntersecting(envInter)) continue;
            b_found_blue = true;
            intersector.addBlueEnvelope(ipath_b, env_b);
        }
        intersector.endBlueConstruction();
        if (!b_found_blue) {
            return null;
        }
        return intersector;
    }

    static boolean isWeakSimple(MultiVertexGeometry geom, double tol) {
        return ((MultiVertexGeometryImpl)geom._getImpl()).getIsSimple(tol) > 0;
    }

    static QuadTree buildQuadTreeForOnePath(MultiPathImpl multipathImpl, int path) {
        Envelope2D extent = new Envelope2D();
        multipathImpl.queryLoosePathEnvelope2D(path, extent);
        QuadTree quad_tree = new QuadTree(extent, 8);
        int hint_index = -1;
        Envelope2D boundingbox = new Envelope2D();
        SegmentIteratorImpl seg_iter = multipathImpl.querySegmentIterator();
        seg_iter.resetToPath(path);
        if (seg_iter.nextPath()) {
            while (seg_iter.hasNextSegment()) {
                Segment segment = seg_iter.nextSegment();
                int index = seg_iter.getStartPointIndex();
                segment.queryLooseEnvelope2D(boundingbox);
                if ((hint_index = quad_tree.insert(index, boundingbox, hint_index)) != -1) continue;
                throw new GeometryException("internal error");
            }
        }
        return quad_tree;
    }
}

