/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.type;

import com.linkedin.coral.com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;

public class RelCrossType
extends RelDataTypeImpl {
    public final ImmutableList<RelDataType> types;

    public RelCrossType(List<RelDataType> types, List<RelDataTypeField> fields) {
        super(fields);
        this.types = ImmutableList.copyOf(types);
        assert (types.size() >= 1);
        for (RelDataType type : types) {
            assert (!(type instanceof RelCrossType));
        }
        this.computeDigest();
    }

    @Override
    public boolean isStruct() {
        return false;
    }

    @Override
    public List<RelDataTypeField> getFieldList() {
        return this.fieldList;
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append("CrossType(");
        for (Ord<RelDataType> type : Ord.zip(this.types)) {
            if (type.i > 0) {
                sb.append(", ");
            }
            if (withDetail) {
                sb.append(((RelDataType)type.e).getFullTypeString());
                continue;
            }
            sb.append(((RelDataType)type.e).toString());
        }
        sb.append(")");
    }
}

