/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.trino.collect.cache.EvictableCacheBuilder;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.fs.SimpleRemoteIterator;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.Storage;
import io.trino.plugin.hive.metastore.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

public class TransactionScopeCachingDirectoryLister
implements DirectoryLister {
    private final Cache<Path, FetchingValueHolder> cache;
    private final DirectoryLister delegate;

    public TransactionScopeCachingDirectoryLister(DirectoryLister delegate, long maxFileStatuses) {
        EvictableCacheBuilder cacheBuilder = EvictableCacheBuilder.newBuilder().maximumWeight(maxFileStatuses).weigher((key, value) -> value.getCachedFilesSize());
        this.cache = cacheBuilder.build();
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public RemoteIterator<LocatedFileStatus> list(FileSystem fs, Table table, Path path) throws IOException {
        FetchingValueHolder cachedValueHolder;
        try {
            cachedValueHolder = (FetchingValueHolder)this.cache.get((Object)path, () -> new FetchingValueHolder(this.delegate.list(fs, table, path)));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable throwable = e.getCause();
            Throwables.throwIfInstanceOf((Throwable)throwable, IOException.class);
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException("Failed to list directory: " + path, throwable);
        }
        if (cachedValueHolder.isFullyCached()) {
            return new SimpleRemoteIterator(cachedValueHolder.getCachedFiles());
        }
        return this.cachingRemoteIterator(cachedValueHolder, path);
    }

    @Override
    public void invalidate(Table table) {
        if (TransactionScopeCachingDirectoryLister.isLocationPresent(table.getStorage())) {
            if (table.getPartitionColumns().isEmpty()) {
                this.cache.invalidate((Object)new Path(table.getStorage().getLocation()));
            } else {
                this.cache.invalidateAll();
            }
        }
        this.delegate.invalidate(table);
    }

    @Override
    public void invalidate(Partition partition) {
        if (TransactionScopeCachingDirectoryLister.isLocationPresent(partition.getStorage())) {
            this.cache.invalidate((Object)new Path(partition.getStorage().getLocation()));
        }
        this.delegate.invalidate(partition);
    }

    private RemoteIterator<LocatedFileStatus> cachingRemoteIterator(final FetchingValueHolder cachedValueHolder, final Path path) {
        return new RemoteIterator<LocatedFileStatus>(){
            private int fileIndex;

            public boolean hasNext() throws IOException {
                try {
                    boolean hasNext = cachedValueHolder.getCachedFile(this.fileIndex).isPresent();
                    TransactionScopeCachingDirectoryLister.this.cache.asMap().replace(path, cachedValueHolder, cachedValueHolder);
                    return hasNext;
                }
                catch (Exception exception) {
                    TransactionScopeCachingDirectoryLister.this.cache.invalidate((Object)path);
                    throw exception;
                }
            }

            public LocatedFileStatus next() throws IOException {
                Preconditions.checkState((boolean)this.hasNext());
                return cachedValueHolder.getCachedFile(this.fileIndex++).orElseThrow();
            }
        };
    }

    @VisibleForTesting
    boolean isCached(Path path) {
        FetchingValueHolder cached = (FetchingValueHolder)this.cache.getIfPresent((Object)path);
        return cached != null && cached.isFullyCached();
    }

    private static boolean isLocationPresent(Storage storage) {
        return storage.getOptionalLocation().isPresent() && StringUtils.isNotEmpty((CharSequence)storage.getLocation());
    }

    private static class FetchingValueHolder {
        private final List<LocatedFileStatus> cachedFiles = Collections.synchronizedList(new ArrayList());
        @Nullable
        @GuardedBy(value="this")
        private RemoteIterator<LocatedFileStatus> fileIterator;
        @Nullable
        @GuardedBy(value="this")
        private Exception exception;

        public FetchingValueHolder(RemoteIterator<LocatedFileStatus> fileIterator) {
            this.fileIterator = Objects.requireNonNull(fileIterator, "fileIterator is null");
        }

        public synchronized boolean isFullyCached() {
            return this.fileIterator == null && this.exception == null;
        }

        public int getCachedFilesSize() {
            return this.cachedFiles.size();
        }

        public Iterator<LocatedFileStatus> getCachedFiles() {
            Preconditions.checkState((boolean)this.isFullyCached());
            return this.cachedFiles.iterator();
        }

        public Optional<LocatedFileStatus> getCachedFile(int index) throws IOException {
            int filesSize = this.cachedFiles.size();
            Preconditions.checkArgument((index >= 0 && index <= filesSize ? 1 : 0) != 0, (String)"File index (%s) out of bounds [0, %s]", (int)index, (int)filesSize);
            if (index < filesSize) {
                return Optional.of(this.cachedFiles.get(index));
            }
            return this.fetchNextCachedFile(index);
        }

        private synchronized Optional<LocatedFileStatus> fetchNextCachedFile(int index) throws IOException {
            if (this.exception != null) {
                throw new IOException("Exception while listing directory", this.exception);
            }
            if (index < this.cachedFiles.size()) {
                return Optional.of(this.cachedFiles.get(index));
            }
            try {
                if (this.fileIterator == null || !this.fileIterator.hasNext()) {
                    this.fileIterator = null;
                    return Optional.empty();
                }
                LocatedFileStatus fileStatus = (LocatedFileStatus)this.fileIterator.next();
                this.cachedFiles.add(fileStatus);
                return Optional.of(fileStatus);
            }
            catch (Exception exception) {
                this.fileIterator = null;
                this.exception = exception;
                throw exception;
            }
        }
    }
}

