/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3select;

import com.google.common.collect.ImmutableSet;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HiveRecordCursorProvider;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.s3select.IonSqlQueryBuilder;
import io.trino.plugin.hive.s3select.S3SelectCsvRecordReader;
import io.trino.plugin.hive.s3select.S3SelectRecordCursor;
import io.trino.plugin.hive.s3select.TrinoS3ClientFactory;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public class S3SelectRecordCursorProvider
implements HiveRecordCursorProvider {
    private static final Set<String> CSV_SERDES = ImmutableSet.of((Object)LazySimpleSerDe.class.getName());
    private final HdfsEnvironment hdfsEnvironment;
    private final TrinoS3ClientFactory s3ClientFactory;

    @Inject
    public S3SelectRecordCursorProvider(HdfsEnvironment hdfsEnvironment, TrinoS3ClientFactory s3ClientFactory) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.s3ClientFactory = Objects.requireNonNull(s3ClientFactory, "s3ClientFactory is null");
    }

    @Override
    public Optional<HiveRecordCursorProvider.ReaderRecordCursorWithProjections> createRecordCursor(Configuration configuration, ConnectorSession session, Path path, long start, long length, long fileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, TypeManager typeManager, boolean s3SelectPushdownEnabled) {
        if (!s3SelectPushdownEnabled) {
            return Optional.empty();
        }
        try {
            this.hdfsEnvironment.getFileSystem(session.getIdentity(), path, configuration);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed getting FileSystem: " + path, (Throwable)e);
        }
        Optional<ReaderColumns> projectedReaderColumns = HivePageSourceProvider.projectBaseColumns(columns);
        effectivePredicate = effectivePredicate.filter((column, domain) -> column.isBaseColumn());
        String serdeName = HiveUtil.getDeserializerClassName(schema);
        if (CSV_SERDES.contains(serdeName)) {
            List<HiveColumnHandle> readerColumns = projectedReaderColumns.map(ReaderColumns::get).map(readColumns -> readColumns.stream().map(HiveColumnHandle.class::cast).collect(Collectors.toUnmodifiableList())).orElse(columns);
            IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder(typeManager);
            String ionSqlQuery = queryBuilder.buildSql(readerColumns, (TupleDomain<HiveColumnHandle>)effectivePredicate);
            S3SelectCsvRecordReader recordReader = new S3SelectCsvRecordReader(configuration, path, start, length, schema, ionSqlQuery, this.s3ClientFactory);
            S3SelectRecordCursor<LongWritable, Text> cursor = new S3SelectRecordCursor<LongWritable, Text>(configuration, path, recordReader, length, schema, readerColumns);
            return Optional.of(new HiveRecordCursorProvider.ReaderRecordCursorWithProjections(cursor, projectedReaderColumns));
        }
        return Optional.empty();
    }
}

