/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.security.Credentials;
import org.apache.hive.hcatalog.common.ErrorType;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.mapreduce.HCatBaseOutputFormat;
import org.apache.hive.hcatalog.mapreduce.HCatFileUtil;
import org.apache.hive.hcatalog.mapreduce.HCatTableInfo;
import org.apache.hive.hcatalog.mapreduce.InternalUtil;
import org.apache.hive.hcatalog.mapreduce.OutputJobInfo;
import org.apache.hive.hcatalog.mapreduce.Security;
import org.apache.hive.hcatalog.mapreduce.StorerInfo;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class HCatOutputFormat
extends HCatBaseOutputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(HCatOutputFormat.class);
    private static int maxDynamicPartitions;
    private static boolean harRequested;

    public static void setOutput(Job job, OutputJobInfo outputJobInfo) throws IOException {
        HCatOutputFormat.setOutput(job.getConfiguration(), job.getCredentials(), outputJobInfo);
    }

    public static void setOutput(Configuration conf, Credentials credentials, OutputJobInfo outputJobInfo) throws IOException {
        IMetaStoreClient client = null;
        try {
            HiveConf hiveConf = HCatUtil.getHiveConf(conf);
            client = HCatUtil.getHiveMetastoreClient(hiveConf);
            Table table = HCatUtil.getTable(client, outputJobInfo.getDatabaseName(), outputJobInfo.getTableName());
            StorageDescriptor sd = table.getTTable().getSd();
            if (sd.isCompressed()) {
                throw new HCatException(ErrorType.ERROR_NOT_SUPPORTED, "Store into a compressed partition from Pig/Mapreduce is not supported");
            }
            if (sd.getBucketCols() != null && !sd.getBucketCols().isEmpty()) {
                throw new HCatException(ErrorType.ERROR_NOT_SUPPORTED, "Store into a partition with bucket definition from Pig/Mapreduce is not supported");
            }
            if (sd.getSortCols() != null && !sd.getSortCols().isEmpty()) {
                throw new HCatException(ErrorType.ERROR_NOT_SUPPORTED, "Store into a partition with sorted column definition from Pig/Mapreduce is not supported");
            }
            if (AcidUtils.isTransactionalTable(table)) {
                throw new HCatException(ErrorType.ERROR_NOT_SUPPORTED, "Store into a transactional table " + table.getFullyQualifiedName() + " from Pig/Mapreduce is not supported");
            }
            String idHash = conf.get("mapreduce.lib.hcatoutput.id");
            if (idHash == null) {
                idHash = String.valueOf(Math.random());
            }
            conf.set("mapreduce.lib.hcatoutput.id", idHash);
            if (table.getTTable().getPartitionKeysSize() == 0) {
                if (outputJobInfo.getPartitionValues() != null && !outputJobInfo.getPartitionValues().isEmpty()) {
                    throw new HCatException(ErrorType.ERROR_INVALID_PARTITION_VALUES, "Partition values specified for non-partitioned table");
                }
                outputJobInfo.setPartitionValues(new HashMap<String, String>());
            } else {
                HashMap<String, String> valueMap = new HashMap<String, String>();
                if (outputJobInfo.getPartitionValues() != null) {
                    for (Map.Entry<String, String> entry : outputJobInfo.getPartitionValues().entrySet()) {
                        valueMap.put(entry.getKey().toLowerCase(), entry.getValue());
                    }
                }
                if (outputJobInfo.getPartitionValues() == null || outputJobInfo.getPartitionValues().size() < table.getTTable().getPartitionKeysSize()) {
                    ArrayList<String> dynamicPartitioningKeys = new ArrayList<String>();
                    boolean firstItem = true;
                    for (FieldSchema fs : table.getPartitionKeys()) {
                        if (valueMap.containsKey(fs.getName().toLowerCase())) continue;
                        dynamicPartitioningKeys.add(fs.getName().toLowerCase());
                    }
                    if (valueMap.size() + dynamicPartitioningKeys.size() != table.getTTable().getPartitionKeysSize()) {
                        throw new HCatException(ErrorType.ERROR_INVALID_PARTITION_VALUES, "Invalid partition keys specified");
                    }
                    outputJobInfo.setDynamicPartitioningKeys(dynamicPartitioningKeys);
                    Object dynHash = conf.get("mapreduce.lib.hcatoutput.dynamic.jobid");
                    if (dynHash == null) {
                        dynHash = String.valueOf(Math.random());
                    }
                    conf.set("mapreduce.lib.hcatoutput.dynamic.jobid", (String)dynHash);
                    String customPattern = conf.get("hcat.dynamic.partitioning.custom.pattern");
                    if (customPattern != null) {
                        HCatFileUtil.setCustomPath(customPattern, outputJobInfo);
                    }
                }
                outputJobInfo.setPartitionValues(valueMap);
            }
            conf.set("dfs.client.read.shortcircuit", "false");
            HCatSchema tableSchema = HCatUtil.extractSchema(table);
            StorerInfo storerInfo = InternalUtil.extractStorerInfo(table.getTTable().getSd(), table.getParameters());
            ArrayList<String> partitionCols = new ArrayList<String>();
            for (FieldSchema schema : table.getPartitionKeys()) {
                partitionCols.add(schema.getName());
            }
            HiveStorageHandler storageHandler = HCatUtil.getStorageHandler(conf, storerInfo);
            outputJobInfo.setTableInfo(HCatTableInfo.valueOf(table.getTTable()));
            outputJobInfo.setOutputSchema(tableSchema);
            harRequested = HCatOutputFormat.getHarRequested(hiveConf);
            outputJobInfo.setHarRequested(harRequested);
            maxDynamicPartitions = HCatOutputFormat.getMaxDynamicPartitions(hiveConf);
            outputJobInfo.setMaximumDynamicPartitions(maxDynamicPartitions);
            HCatUtil.configureOutputStorageHandler(storageHandler, conf, outputJobInfo);
            Path tblPath = new Path(table.getTTable().getSd().getLocation());
            FsPermission.setUMask((Configuration)conf, (FsPermission)FsPermission.getDefault().applyUMask(tblPath.getFileSystem(conf).getFileStatus(tblPath).getPermission()));
            if (Security.getInstance().isSecurityEnabled()) {
                Security.getInstance().handleSecurity(credentials, outputJobInfo, client, conf, harRequested);
            }
        }
        catch (Exception e) {
            try {
                if (e instanceof HCatException) {
                    throw (HCatException)e;
                }
                throw new HCatException(ErrorType.ERROR_SET_OUTPUT, (Throwable)e);
            }
            catch (Throwable throwable) {
                HCatUtil.closeHiveClientQuietly(client);
                throw throwable;
            }
        }
        HCatUtil.closeHiveClientQuietly(client);
    }

    public static void setSchema(Job job, HCatSchema schema) throws IOException {
        HCatOutputFormat.setSchema(job.getConfiguration(), schema);
    }

    public static void setSchema(Configuration conf, HCatSchema schema) throws IOException {
        OutputJobInfo jobInfo = HCatOutputFormat.getJobInfo(conf);
        Map<String, String> partMap = jobInfo.getPartitionValues();
        HCatOutputFormat.setPartDetails(jobInfo, schema, partMap);
        conf.set("mapreduce.lib.hcatoutput.info", HCatUtil.serialize(jobInfo));
    }

    public RecordWriter<WritableComparable<?>, HCatRecord> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return this.getOutputFormat((JobContext)context).getRecordWriter(context);
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return this.getOutputFormat((JobContext)context).getOutputCommitter(context);
    }

    private static int getMaxDynamicPartitions(HiveConf hConf) {
        int maxDynamicPartitions = -1;
        return maxDynamicPartitions;
    }

    private static boolean getHarRequested(HiveConf hConf) {
        return hConf.getBoolVar(HiveConf.ConfVars.HIVEARCHIVEENABLED);
    }
}

