/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.deser.impl;

import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.core.JsonParser;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.core.JsonProcessingException;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.DeserializationContext;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.JavaType;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.JsonDeserializer;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.PropertyName;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.deser.SettableBeanProperty;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.introspect.AnnotatedMember;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.util.Annotations;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public final class MethodProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final AnnotatedMethod _annotated;
    protected final transient Method _setter;

    public MethodProperty(BeanPropertyDefinition propDef, JavaType type, TypeDeserializer typeDeser, Annotations contextAnnotations, AnnotatedMethod method) {
        super(propDef, type, typeDeser, contextAnnotations);
        this._annotated = method;
        this._setter = method.getAnnotated();
    }

    protected MethodProperty(MethodProperty src, JsonDeserializer<?> deser) {
        super((SettableBeanProperty)src, deser);
        this._annotated = src._annotated;
        this._setter = src._setter;
    }

    protected MethodProperty(MethodProperty src, PropertyName newName) {
        super((SettableBeanProperty)src, newName);
        this._annotated = src._annotated;
        this._setter = src._setter;
    }

    protected MethodProperty(MethodProperty src, Method m) {
        super(src);
        this._annotated = src._annotated;
        this._setter = m;
    }

    @Override
    public MethodProperty withName(PropertyName newName) {
        return new MethodProperty(this, newName);
    }

    @Override
    public MethodProperty withValueDeserializer(JsonDeserializer<?> deser) {
        return new MethodProperty(this, deser);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._annotated.getAnnotation(acls);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._annotated;
    }

    @Override
    public void deserializeAndSet(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException, JsonProcessingException {
        this.set(instance, this.deserialize(jp, ctxt));
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException, JsonProcessingException {
        return this.setAndReturn(instance, this.deserialize(jp, ctxt));
    }

    @Override
    public final void set(Object instance, Object value) throws IOException {
        try {
            this._setter.invoke(instance, value);
        }
        catch (Exception e) {
            this._throwAsIOE(e, value);
        }
    }

    @Override
    public Object setAndReturn(Object instance, Object value) throws IOException {
        try {
            Object result = this._setter.invoke(instance, value);
            return result == null ? instance : result;
        }
        catch (Exception e) {
            this._throwAsIOE(e, value);
            return null;
        }
    }

    Object readResolve() {
        return new MethodProperty(this, this._annotated.getAnnotated());
    }
}

