/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.eclipse.jetty.util.log;

import io.trino.hadoop.$internal.org.eclipse.jetty.util.log.Log;
import io.trino.hadoop.$internal.org.eclipse.jetty.util.log.Logger;
import io.trino.hadoop.$internal.org.eclipse.jetty.util.log.StdErrLog;
import java.util.HashSet;
import java.util.Set;

public class StacklessLogging
implements AutoCloseable {
    private final Set<StdErrLog> squelched = new HashSet<StdErrLog>();

    public StacklessLogging(Class<?> ... classesToSquelch) {
        for (Class<?> clazz : classesToSquelch) {
            StdErrLog stdErrLog;
            Logger log = Log.getLogger(clazz);
            if (!(log instanceof StdErrLog) || (stdErrLog = (StdErrLog)log).isHideStacks()) continue;
            stdErrLog.setHideStacks(true);
            this.squelched.add(stdErrLog);
        }
    }

    public StacklessLogging(Logger ... logs) {
        for (Logger log : logs) {
            StdErrLog stdErrLog;
            if (!(log instanceof StdErrLog) || (stdErrLog = (StdErrLog)log).isHideStacks()) continue;
            stdErrLog.setHideStacks(true);
            this.squelched.add(stdErrLog);
        }
    }

    @Override
    public void close() {
        for (StdErrLog log : this.squelched) {
            log.setHideStacks(false);
        }
    }
}

