/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import io.trino.hadoop.$internal.com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
abstract class InodeTree<T> {
    static final Path SlashPath = new Path("/");
    private final INode<T> root;
    private final INodeLink<T> rootFallbackLink;
    private final String homedirPrefix;
    private List<MountPoint<T>> mountPoints = new ArrayList<MountPoint<T>>();

    static String[] breakIntoPathComponents(String path) {
        return path == null ? null : path.split("/");
    }

    private void createLink(String src, String target, LinkType linkType, String settings, UserGroupInformation aUgi, Configuration config) throws URISyntaxException, IOException, FileAlreadyExistsException, UnsupportedFileSystemException {
        INodeLink<T> newLink;
        String iPath;
        int i;
        Path srcPath = new Path(src);
        if (!srcPath.isAbsoluteAndSchemeAuthorityNull()) {
            throw new IOException("ViewFs: Non absolute mount name in config:" + src);
        }
        String[] srcPaths = InodeTree.breakIntoPathComponents(src);
        Preconditions.checkState(this.root.isInternalDir());
        INodeDir curInode = this.getRootDir();
        for (i = 1; i < srcPaths.length - 1; ++i) {
            iPath = srcPaths[i];
            INode<T> nextInode = curInode.resolveInternal(iPath);
            if (nextInode == null) {
                INodeDir<T> newDir = curInode.addDir(iPath, aUgi);
                newDir.setInternalDirFs(this.getTargetFileSystem(newDir));
                nextInode = newDir;
            }
            if (nextInode.isLink()) {
                throw new FileAlreadyExistsException("Path " + nextInode.fullPath + " already exists as link");
            }
            assert (nextInode.isInternalDir());
            curInode = (INodeDir)nextInode;
        }
        iPath = srcPaths[i];
        if (curInode.resolveInternal(iPath) != null) {
            StringBuilder strB = new StringBuilder(srcPaths[0]);
            for (int j = 1; j <= i; ++j) {
                strB.append('/').append(srcPaths[j]);
            }
            throw new FileAlreadyExistsException("Path " + strB + " already exists as dir; cannot create link here");
        }
        String fullPath = curInode.fullPath + (curInode == this.root ? "" : "/") + iPath;
        switch (linkType) {
            case SINGLE: {
                newLink = new INodeLink<T>(fullPath, aUgi, this.getTargetFileSystem(new URI(target)), new URI(target));
                break;
            }
            case SINGLE_FALLBACK: 
            case MERGE_SLASH: {
                throw new IllegalArgumentException("Unexpected linkType: " + (Object)((Object)linkType));
            }
            case MERGE: 
            case NFLY: {
                URI[] targetUris = StringUtils.stringToURI(StringUtils.getStrings(target));
                newLink = new INodeLink<T>(fullPath, aUgi, this.getTargetFileSystem(settings, targetUris), targetUris);
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)linkType) + ": Infeasible linkType");
            }
        }
        curInode.addLink(iPath, newLink);
        this.mountPoints.add(new MountPoint<T>(src, newLink));
    }

    protected abstract T getTargetFileSystem(URI var1) throws UnsupportedFileSystemException, URISyntaxException, IOException;

    protected abstract T getTargetFileSystem(INodeDir<T> var1) throws URISyntaxException;

    protected abstract T getTargetFileSystem(String var1, URI[] var2) throws UnsupportedFileSystemException, URISyntaxException, IOException;

    private INodeDir<T> getRootDir() {
        Preconditions.checkState(this.root.isInternalDir());
        return (INodeDir)this.root;
    }

    private INodeLink<T> getRootLink() {
        Preconditions.checkState(this.root.isLink());
        return (INodeLink)this.root;
    }

    private boolean hasFallbackLink() {
        return this.rootFallbackLink != null;
    }

    private INodeLink<T> getRootFallbackLink() {
        Preconditions.checkState(this.root.isInternalDir());
        return this.rootFallbackLink;
    }

    protected InodeTree(Configuration config, String viewName) throws UnsupportedFileSystemException, URISyntaxException, FileAlreadyExistsException, IOException {
        String mountTableName = viewName;
        if (mountTableName == null) {
            mountTableName = "default";
        }
        this.homedirPrefix = ConfigUtil.getHomeDirValue(config, mountTableName);
        boolean isMergeSlashConfigured = false;
        String mergeSlashTarget = null;
        LinkedList<LinkEntry> linkEntries = new LinkedList<LinkEntry>();
        String mountTablePrefix = "fs.viewfs.mounttable." + mountTableName + ".";
        String linkPrefix = "link.";
        String linkFallbackPrefix = "linkFallback";
        String linkMergePrefix = "linkMerge.";
        String linkMergeSlashPrefix = "linkMergeSlash";
        boolean gotMountTableEntry = false;
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        for (Map.Entry<String, String> si : config) {
            LinkType linkType;
            String key = si.getKey();
            if (!key.startsWith(mountTablePrefix)) continue;
            gotMountTableEntry = true;
            String src = key.substring(mountTablePrefix.length());
            String settings = null;
            if (src.startsWith("link.")) {
                if ((src = src.substring("link.".length())).equals(SlashPath.toString())) {
                    throw new UnsupportedFileSystemException("Unexpected mount table link entry '" + key + "'. Use " + "linkMergeSlash" + " instead!");
                }
                linkType = LinkType.SINGLE;
            } else if (src.startsWith("linkFallback")) {
                if (src.length() != "linkFallback".length()) {
                    throw new IOException("ViewFs: Mount points initialization error. Invalid linkFallback entry in config: " + src);
                }
                linkType = LinkType.SINGLE_FALLBACK;
            } else if (src.startsWith("linkMerge.")) {
                src = src.substring("linkMerge.".length());
                linkType = LinkType.MERGE;
            } else if (src.startsWith("linkMergeSlash")) {
                if (src.length() != "linkMergeSlash".length()) {
                    throw new IOException("ViewFs: Mount points initialization error. Invalid linkMergeSlash entry in config: " + src);
                }
                linkType = LinkType.MERGE_SLASH;
            } else if (src.startsWith("linkNfly")) {
                src = src.substring("linkNfly".length() + 1);
                settings = src.substring(0, src.indexOf(46));
                src = src.substring(settings.length() + 1);
                linkType = LinkType.NFLY;
            } else {
                if (src.startsWith("homedir")) continue;
                throw new IOException("ViewFs: Cannot initialize: Invalid entry in Mount table in config: " + src);
            }
            String target = si.getValue();
            if (linkType != LinkType.MERGE_SLASH) {
                if (isMergeSlashConfigured) {
                    throw new IOException("Mount table " + mountTableName + " has already been configured with a merge slash link. A regular link should not be added.");
                }
                linkEntries.add(new LinkEntry(src, target, linkType, settings, ugi, config));
                continue;
            }
            if (!linkEntries.isEmpty()) {
                throw new IOException("Mount table " + mountTableName + " has already been configured with regular links. A merge slash link should not be configured.");
            }
            if (isMergeSlashConfigured) {
                throw new IOException("Mount table " + mountTableName + " has already been configured with a merge slash link. Multiple merge slash links for the same mount table is not allowed.");
            }
            isMergeSlashConfigured = true;
            mergeSlashTarget = target;
        }
        if (isMergeSlashConfigured) {
            Preconditions.checkNotNull(mergeSlashTarget);
            this.root = new INodeLink<T>(mountTableName, ugi, this.getTargetFileSystem(new URI(mergeSlashTarget)), new URI(mergeSlashTarget));
            this.mountPoints.add(new MountPoint("/", (INodeLink)this.root));
            this.rootFallbackLink = null;
        } else {
            this.root = new INodeDir("/", UserGroupInformation.getCurrentUser());
            this.getRootDir().setInternalDirFs(this.getTargetFileSystem(this.getRootDir()));
            this.getRootDir().setRoot(true);
            INodeLink<T> fallbackLink = null;
            for (LinkEntry le : linkEntries) {
                if (le.isLinkType(LinkType.SINGLE_FALLBACK)) {
                    if (fallbackLink != null) {
                        throw new IOException("Mount table " + mountTableName + " has already been configured with a link fallback. Multiple fallback links for the same mount table is not allowed.");
                    }
                    fallbackLink = new INodeLink<T>(mountTableName, ugi, this.getTargetFileSystem(new URI(le.getTarget())), new URI(le.getTarget()));
                    continue;
                }
                this.createLink(le.getSrc(), le.getTarget(), le.getLinkType(), le.getSettings(), le.getUgi(), le.getConfig());
            }
            this.rootFallbackLink = fallbackLink;
        }
        if (!gotMountTableEntry) {
            throw new IOException("ViewFs: Cannot initialize: Empty Mount table in config for viewfs://" + mountTableName + "/");
        }
    }

    ResolveResult<T> resolve(String p, boolean resolveLastComponent) throws FileNotFoundException {
        Path remainingPath;
        int i;
        String[] path = InodeTree.breakIntoPathComponents(p);
        if (path.length <= 1) {
            T targetFs = this.root.isInternalDir() ? this.getRootDir().getInternalDirFs() : this.getRootLink().getTargetFileSystem();
            ResolveResult<T> res = new ResolveResult<T>(ResultKind.INTERNAL_DIR, targetFs, this.root.fullPath, SlashPath);
            return res;
        }
        if (this.root.isLink()) {
            StringBuilder remainingPathStr = new StringBuilder();
            for (int i2 = 1; i2 < path.length; ++i2) {
                remainingPathStr.append("/").append(path[i2]);
            }
            Path remainingPath2 = new Path(remainingPathStr.toString());
            ResolveResult<T> res = new ResolveResult<T>(ResultKind.EXTERNAL_DIR, this.getRootLink().getTargetFileSystem(), this.root.fullPath, remainingPath2);
            return res;
        }
        Preconditions.checkState(this.root.isInternalDir());
        INodeDir curInode = this.getRootDir();
        for (i = 1; i < path.length - (resolveLastComponent ? 0 : 1); ++i) {
            INode<T> nextInode = curInode.resolveInternal(path[i]);
            if (nextInode == null) {
                if (this.hasFallbackLink()) {
                    return new ResolveResult<T>(ResultKind.EXTERNAL_DIR, this.getRootFallbackLink().getTargetFileSystem(), this.root.fullPath, new Path(p));
                }
                StringBuilder failedAt = new StringBuilder(path[0]);
                for (int j = 1; j <= i; ++j) {
                    failedAt.append('/').append(path[j]);
                }
                throw new FileNotFoundException("File/Directory does not exist: " + failedAt.toString());
            }
            if (nextInode.isLink()) {
                Path remainingPath3;
                INodeLink link = (INodeLink)nextInode;
                if (i >= path.length - 1) {
                    remainingPath3 = SlashPath;
                } else {
                    StringBuilder remainingPathStr = new StringBuilder("/" + path[i + 1]);
                    for (int j = i + 2; j < path.length; ++j) {
                        remainingPathStr.append('/').append(path[j]);
                    }
                    remainingPath3 = new Path(remainingPathStr.toString());
                }
                ResolveResult res = new ResolveResult(ResultKind.EXTERNAL_DIR, link.getTargetFileSystem(), nextInode.fullPath, remainingPath3);
                return res;
            }
            if (!nextInode.isInternalDir()) continue;
            curInode = (INodeDir)nextInode;
        }
        if (resolveLastComponent) {
            remainingPath = SlashPath;
        } else {
            StringBuilder remainingPathStr = new StringBuilder("/" + path[i]);
            for (int j = i + 1; j < path.length; ++j) {
                remainingPathStr.append('/').append(path[j]);
            }
            remainingPath = new Path(remainingPathStr.toString());
        }
        ResolveResult<T> res = new ResolveResult<T>(ResultKind.INTERNAL_DIR, curInode.getInternalDirFs(), curInode.fullPath, remainingPath);
        return res;
    }

    List<MountPoint<T>> getMountPoints() {
        return this.mountPoints;
    }

    String getHomeDirPrefixValue() {
        return this.homedirPrefix;
    }

    static class ResolveResult<T> {
        final ResultKind kind;
        final T targetFileSystem;
        final String resolvedPath;
        final Path remainingPath;

        ResolveResult(ResultKind k, T targetFs, String resolveP, Path remainingP) {
            this.kind = k;
            this.targetFileSystem = targetFs;
            this.resolvedPath = resolveP;
            this.remainingPath = remainingP;
        }

        boolean isInternalDir() {
            return this.kind == ResultKind.INTERNAL_DIR;
        }
    }

    private static class LinkEntry {
        private final String src;
        private final String target;
        private final LinkType linkType;
        private final String settings;
        private final UserGroupInformation ugi;
        private final Configuration config;

        LinkEntry(String src, String target, LinkType linkType, String settings, UserGroupInformation ugi, Configuration config) {
            this.src = src;
            this.target = target;
            this.linkType = linkType;
            this.settings = settings;
            this.ugi = ugi;
            this.config = config;
        }

        String getSrc() {
            return this.src;
        }

        String getTarget() {
            return this.target;
        }

        LinkType getLinkType() {
            return this.linkType;
        }

        boolean isLinkType(LinkType type) {
            return this.linkType == type;
        }

        String getSettings() {
            return this.settings;
        }

        UserGroupInformation getUgi() {
            return this.ugi;
        }

        Configuration getConfig() {
            return this.config;
        }
    }

    static class INodeLink<T>
    extends INode<T> {
        final URI[] targetDirLinkList;
        final T targetFileSystem;

        INodeLink(String pathToNode, UserGroupInformation aUgi, T targetMergeFs, URI[] aTargetDirLinkList) {
            super(pathToNode, aUgi);
            this.targetFileSystem = targetMergeFs;
            this.targetDirLinkList = aTargetDirLinkList;
        }

        INodeLink(String pathToNode, UserGroupInformation aUgi, T targetFs, URI aTargetDirLink) {
            super(pathToNode, aUgi);
            this.targetFileSystem = targetFs;
            this.targetDirLinkList = new URI[1];
            this.targetDirLinkList[0] = aTargetDirLink;
        }

        Path getTargetLink() {
            StringBuilder result = new StringBuilder(this.targetDirLinkList[0].toString());
            for (int i = 1; i < this.targetDirLinkList.length; ++i) {
                result.append(',').append(this.targetDirLinkList[i].toString());
            }
            return new Path(result.toString());
        }

        @Override
        boolean isInternalDir() {
            return false;
        }

        public T getTargetFileSystem() {
            return this.targetFileSystem;
        }
    }

    static enum LinkType {
        SINGLE,
        SINGLE_FALLBACK,
        MERGE,
        MERGE_SLASH,
        NFLY;

    }

    static class INodeDir<T>
    extends INode<T> {
        private final Map<String, INode<T>> children = new HashMap<String, INode<T>>();
        private T internalDirFs = null;
        private boolean isRoot = false;

        INodeDir(String pathToNode, UserGroupInformation aUgi) {
            super(pathToNode, aUgi);
        }

        @Override
        boolean isInternalDir() {
            return true;
        }

        T getInternalDirFs() {
            return this.internalDirFs;
        }

        void setInternalDirFs(T internalDirFs) {
            this.internalDirFs = internalDirFs;
        }

        void setRoot(boolean root) {
            this.isRoot = root;
        }

        boolean isRoot() {
            return this.isRoot;
        }

        Map<String, INode<T>> getChildren() {
            return Collections.unmodifiableMap(this.children);
        }

        INode<T> resolveInternal(String pathComponent) {
            return this.children.get(pathComponent);
        }

        INodeDir<T> addDir(String pathComponent, UserGroupInformation aUgi) throws FileAlreadyExistsException {
            if (this.children.containsKey(pathComponent)) {
                throw new FileAlreadyExistsException();
            }
            INodeDir<T> newDir = new INodeDir<T>(this.fullPath + (this.isRoot() ? "" : "/") + pathComponent, aUgi);
            this.children.put(pathComponent, newDir);
            return newDir;
        }

        void addLink(String pathComponent, INodeLink<T> link) throws FileAlreadyExistsException {
            if (this.children.containsKey(pathComponent)) {
                throw new FileAlreadyExistsException();
            }
            this.children.put(pathComponent, link);
        }
    }

    static abstract class INode<T> {
        final String fullPath;

        public INode(String pathToNode, UserGroupInformation aUgi) {
            this.fullPath = pathToNode;
        }

        abstract boolean isInternalDir();

        boolean isLink() {
            return !this.isInternalDir();
        }
    }

    static class MountPoint<T> {
        String src;
        INodeLink<T> target;

        MountPoint(String srcPath, INodeLink<T> mountLink) {
            this.src = srcPath;
            this.target = mountLink;
        }
    }

    static enum ResultKind {
        INTERNAL_DIR,
        EXTERNAL_DIR;

    }
}

