/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.policy;

import alluxio.client.block.policy.options.GetWorkerOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.util.CommonUtils;
import alluxio.wire.WorkerNetAddress;

public interface BlockLocationPolicy {
    @Nullable
    public WorkerNetAddress getWorker(GetWorkerOptions var1);

    public static class Factory {
        private Factory() {
        }

        public static BlockLocationPolicy create(String blockLocationPolicyClass, AlluxioConfiguration conf) {
            try {
                Class<?> clazz = Class.forName(blockLocationPolicyClass);
                return (BlockLocationPolicy)CommonUtils.createNewClassInstance(clazz, new Class[]{AlluxioConfiguration.class}, new Object[]{conf});
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

