/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel;

import com.linkedin.coral.common.HiveMetastoreClient;
import com.linkedin.coral.common.ToRelConverter;
import com.linkedin.coral.common.functions.Function;
import com.linkedin.coral.hive.hive2rel.DaliOperatorTable;
import com.linkedin.coral.hive.hive2rel.HiveConvertletTable;
import com.linkedin.coral.hive.hive2rel.HiveRelBuilder;
import com.linkedin.coral.hive.hive2rel.HiveRelConverter;
import com.linkedin.coral.hive.hive2rel.HiveSqlConformance;
import com.linkedin.coral.hive.hive2rel.HiveSqlToRelConverter;
import com.linkedin.coral.hive.hive2rel.HiveSqlValidator;
import com.linkedin.coral.hive.hive2rel.HiveViewExpander;
import com.linkedin.coral.hive.hive2rel.functions.HiveFunctionResolver;
import com.linkedin.coral.hive.hive2rel.functions.StaticHiveFunctionRegistry;
import com.linkedin.coral.hive.hive2rel.parsetree.ParseTreeBuilder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.hadoop.hive.metastore.api.Table;

public class HiveToRelConverter
extends ToRelConverter {
    private final ParseTreeBuilder parseTreeBuilder;
    private SqlToRelConverter sqlToRelConverter;
    private final HiveFunctionResolver functionResolver = new HiveFunctionResolver(new StaticHiveFunctionRegistry(), new ConcurrentHashMap<String, Function>());
    private final SqlValidator sqlValidator = new HiveSqlValidator(this.getOperatorTable(), this.getCalciteCatalogReader(), (JavaTypeFactory)this.getRelBuilder().getTypeFactory(), HiveSqlConformance.HIVE_SQL);

    public HiveToRelConverter(HiveMetastoreClient hiveMetastoreClient) {
        super(hiveMetastoreClient);
        this.parseTreeBuilder = new ParseTreeBuilder(this.functionResolver);
    }

    public HiveToRelConverter(Map<String, Map<String, List<String>>> localMetaStore) {
        super(localMetaStore);
        this.parseTreeBuilder = new ParseTreeBuilder(this.functionResolver);
    }

    protected SqlRexConvertletTable getConvertletTable() {
        return new HiveConvertletTable();
    }

    protected SqlValidator getSqlValidator() {
        return this.sqlValidator;
    }

    protected SqlOperatorTable getOperatorTable() {
        return ChainedSqlOperatorTable.of((SqlOperatorTable[])new SqlOperatorTable[]{SqlStdOperatorTable.instance(), new DaliOperatorTable(this.functionResolver)});
    }

    protected SqlToRelConverter getSqlToRelConverter() {
        if (this.sqlToRelConverter == null) {
            this.sqlToRelConverter = new HiveSqlToRelConverter(new HiveViewExpander(this), this.getSqlValidator(), (Prepare.CatalogReader)this.getCalciteCatalogReader(), RelOptCluster.create((RelOptPlanner)new VolcanoPlanner(), (RexBuilder)this.getRelBuilder().getRexBuilder()), this.getConvertletTable(), SqlToRelConverter.configBuilder().withRelBuilderFactory(HiveRelBuilder.LOGICAL_BUILDER).build());
        }
        return this.sqlToRelConverter;
    }

    protected SqlNode toSqlNode(String sql, Table hiveView) {
        return this.parseTreeBuilder.process(HiveToRelConverter.trimParenthesis(sql), hiveView);
    }

    protected RelNode standardizeRel(RelNode relNode) {
        return new HiveRelConverter().convert(relNode);
    }

    private static String trimParenthesis(String value) {
        String str = value.trim();
        if (str.startsWith("(") && str.endsWith(")")) {
            return HiveToRelConverter.trimParenthesis(str.substring(1, str.length() - 1));
        }
        return str;
    }
}

