/*
 * Decompiled with CFR 0.152.
 */
package io.trino.rcfile.text;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.rcfile.RcFileCorruptionException;
import io.trino.rcfile.text.BlockEncoding;
import io.trino.rcfile.text.TextColumnEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import java.util.List;

public class StructEncoding
extends BlockEncoding {
    private final boolean lastColumnTakesRest;
    private final List<TextColumnEncoding> structFields;

    public StructEncoding(Type type, Slice nullSequence, byte[] separators, Byte escapeByte, boolean lastColumnTakesRest, List<TextColumnEncoding> structFields) {
        super(type, nullSequence, separators, escapeByte);
        this.lastColumnTakesRest = lastColumnTakesRest;
        this.structFields = structFields;
    }

    @Override
    public void encodeValueInto(int depth, Block block, int position, SliceOutput output) throws RcFileCorruptionException {
        byte separator = this.getSeparator(depth);
        Block row = (Block)block.getObject(position, Block.class);
        for (int fieldIndex = 0; fieldIndex < this.structFields.size(); ++fieldIndex) {
            if (fieldIndex > 0) {
                output.writeByte((int)separator);
            }
            if (row.isNull(fieldIndex)) {
                output.writeBytes(this.nullSequence);
                continue;
            }
            this.structFields.get(fieldIndex).encodeValueInto(depth + 1, row, fieldIndex, output);
        }
    }

    @Override
    public void decodeValueInto(int depth, BlockBuilder builder, Slice slice, int offset, int length) throws RcFileCorruptionException {
        byte separator = this.getSeparator(depth);
        int end = offset + length;
        BlockBuilder structBuilder = builder.beginBlockEntry();
        int elementOffset = offset;
        int fieldIndex = 0;
        while (!(offset >= end || this.lastColumnTakesRest && fieldIndex >= this.structFields.size())) {
            byte currentByte = slice.getByte(offset);
            if (currentByte == separator) {
                this.decodeElementValueInto(depth, fieldIndex, structBuilder, slice, elementOffset, offset - elementOffset);
                elementOffset = offset + 1;
                ++fieldIndex;
            } else if (this.isEscapeByte(currentByte) && offset + 1 < length) {
                ++offset;
            }
            ++offset;
        }
        this.decodeElementValueInto(depth, fieldIndex, structBuilder, slice, elementOffset, end - elementOffset);
        ++fieldIndex;
        while (fieldIndex < this.structFields.size()) {
            structBuilder.appendNull();
            ++fieldIndex;
        }
        builder.closeEntry();
    }

    private void decodeElementValueInto(int depth, int fieldIndex, BlockBuilder builder, Slice slice, int offset, int length) throws RcFileCorruptionException {
        if (fieldIndex > this.structFields.size()) {
            return;
        }
        if (this.isNullSequence(slice, offset, length)) {
            builder.appendNull();
        } else {
            this.structFields.get(fieldIndex).decodeValueInto(depth + 1, builder, slice, offset, length);
        }
    }
}

