/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakePageSource;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeSplit;
import io.trino.plugin.deltalake.DeltaLakeTableHandle;
import io.trino.plugin.deltalake.DeltaLakeUpdatablePageSource;
import io.trino.plugin.deltalake.DeltaLakeUpdateResult;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TypeManager;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTimeZone;

public class DeltaLakePageSourceProvider
implements ConnectorPageSourceProvider {
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;
    private final ParquetReaderOptions parquetReaderOptions;
    private final int domainCompactionThreshold;
    private final DateTimeZone parquetDateTimeZone;
    private final ExecutorService executorService;
    private final TypeManager typeManager;
    private final JsonCodec<DeltaLakeUpdateResult> updateResultJsonCodec;

    @Inject
    public DeltaLakePageSourceProvider(HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats fileFormatDataSourceStats, ParquetReaderConfig parquetReaderConfig, DeltaLakeConfig deltaLakeConfig, HiveConfig hiveConfig, ExecutorService executorService, TypeManager typeManager, JsonCodec<DeltaLakeUpdateResult> updateResultJsonCodec) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
        this.parquetReaderOptions = Objects.requireNonNull(parquetReaderConfig, "parquetReaderConfig is null").toParquetReaderOptions();
        this.domainCompactionThreshold = Objects.requireNonNull(deltaLakeConfig, "deltaLakeConfig is null").getDomainCompactionThreshold();
        this.parquetDateTimeZone = Objects.requireNonNull(hiveConfig, "hiveConfig is null").getParquetDateTimeZone();
        this.executorService = Objects.requireNonNull(executorService, "executorService is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.updateResultJsonCodec = Objects.requireNonNull(updateResultJsonCodec, "deleteResultJsonCodec is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit connectorSplit, ConnectorTableHandle connectorTable, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        DeltaLakeSplit split = (DeltaLakeSplit)connectorSplit;
        DeltaLakeTableHandle table = (DeltaLakeTableHandle)connectorTable;
        TupleDomain filteredSplitPredicate = TupleDomain.intersect((List)ImmutableList.of(table.getNonPartitionConstraint(), split.getStatisticsPredicate(), (Object)dynamicFilter.getCurrentPredicate().transformKeys(DeltaLakeColumnHandle.class::cast)));
        if (filteredSplitPredicate.isNone()) {
            return new EmptyPageSource();
        }
        List deltaLakeColumns = (List)columns.stream().map(DeltaLakeColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        Map<String, Optional<String>> partitionKeys = split.getPartitionKeys();
        List regularColumns = (List)deltaLakeColumns.stream().filter(column -> column.getColumnType() == DeltaLakeColumnType.REGULAR).collect(ImmutableList.toImmutableList());
        List hiveColumnHandles = (List)regularColumns.stream().map(DeltaLakeColumnHandle::toHiveColumnHandle).collect(ImmutableList.toImmutableList());
        Path path = new Path(split.getPath());
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
        TupleDomain<HiveColumnHandle> parquetPredicate = DeltaLakePageSourceProvider.getParquetTupleDomain((TupleDomain<DeltaLakeColumnHandle>)filteredSplitPredicate.simplify(this.domainCompactionThreshold));
        if (table.getWriteType().isPresent()) {
            return new DeltaLakeUpdatablePageSource(table, deltaLakeColumns, partitionKeys, split.getPath(), split.getFileSize(), split.getFileModifiedTime(), session, this.executorService, this.hdfsEnvironment, hdfsContext, this.parquetDateTimeZone, this.parquetReaderOptions, parquetPredicate, this.typeManager, this.updateResultJsonCodec);
        }
        ReaderPageSource pageSource = ParquetPageSourceFactory.createPageSource((Path)path, (long)split.getStart(), (long)split.getLength(), (long)split.getFileSize(), (List)hiveColumnHandles, parquetPredicate, (boolean)true, (HdfsEnvironment)this.hdfsEnvironment, (Configuration)this.hdfsEnvironment.getConfiguration(hdfsContext, path), (ConnectorIdentity)session.getIdentity(), (DateTimeZone)this.parquetDateTimeZone, (FileFormatDataSourceStats)this.fileFormatDataSourceStats, (ParquetReaderOptions)this.parquetReaderOptions.withMaxReadBlockSize(DeltaLakeSessionProperties.getParquetMaxReadBlockSize(session)).withUseColumnIndex(HiveSessionProperties.isParquetUseColumnIndex((ConnectorSession)session)));
        Verify.verify((boolean)pageSource.getReaderColumns().isEmpty(), (String)"All columns expected to be base columns", (Object[])new Object[0]);
        return new DeltaLakePageSource(deltaLakeColumns, partitionKeys, pageSource.get(), split.getPath(), split.getFileSize(), split.getFileModifiedTime());
    }

    private static TupleDomain<HiveColumnHandle> getParquetTupleDomain(TupleDomain<DeltaLakeColumnHandle> effectivePredicate) {
        if (effectivePredicate.isNone()) {
            return TupleDomain.none();
        }
        ImmutableMap.Builder predicate = ImmutableMap.builder();
        ((Map)effectivePredicate.getDomains().get()).forEach((columnHandle, domain) -> {
            String baseType = columnHandle.getType().getTypeSignature().getBase();
            if (!(baseType.equals("map") || baseType.equals("array") || baseType.equals("row"))) {
                HiveColumnHandle hiveColumnHandle = columnHandle.toHiveColumnHandle();
                predicate.put((Object)hiveColumnHandle, domain);
            }
        });
        return TupleDomain.withColumnDomains((Map)predicate.buildOrThrow());
    }
}

