/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorSplitSource;
import io.trino.plugin.deltalake.AnalyzeHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakeMetadata;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeSplit;
import io.trino.plugin.deltalake.DeltaLakeSplitSource;
import io.trino.plugin.deltalake.DeltaLakeTableHandle;
import io.trino.plugin.deltalake.metastore.DeltaLakeMetastore;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TypeManager;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;

public class DeltaLakeSplitManager
implements ConnectorSplitManager {
    private final TypeManager typeManager;
    private final BiFunction<ConnectorSession, HiveTransactionHandle, DeltaLakeMetastore> metastoreProvider;
    private final ExecutorService executor;
    private final int maxInitialSplits;
    private final int maxSplitsPerSecond;
    private final int maxOutstandingSplits;

    @Inject
    public DeltaLakeSplitManager(TypeManager typeManager, BiFunction<ConnectorSession, HiveTransactionHandle, DeltaLakeMetastore> metastoreProvider, ExecutorService executor, DeltaLakeConfig config) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.metastoreProvider = Objects.requireNonNull(metastoreProvider, "metastoreProvider is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(config, "config is null");
        this.maxInitialSplits = config.getMaxInitialSplits();
        this.maxSplitsPerSecond = config.getMaxSplitsPerSecond();
        this.maxOutstandingSplits = config.getMaxOutstandingSplits();
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle handle, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy, DynamicFilter dynamicFilter, Constraint constraint) {
        DeltaLakeTableHandle deltaLakeTableHandle = (DeltaLakeTableHandle)handle;
        if (deltaLakeTableHandle.getEnforcedPartitionConstraint().isNone() || deltaLakeTableHandle.getNonPartitionConstraint().isNone()) {
            if (deltaLakeTableHandle.isRecordScannedFiles()) {
                return new FixedSplitSource((Iterable)ImmutableList.of(), (List)ImmutableList.of());
            }
            return new FixedSplitSource((Iterable)ImmutableList.of());
        }
        DeltaLakeSplitSource splitSource = new DeltaLakeSplitSource(deltaLakeTableHandle.getSchemaTableName(), this.getSplits(transaction, deltaLakeTableHandle, session, deltaLakeTableHandle.getMaxScannedFileSize(), dynamicFilter.getColumnsCovered(), constraint), this.executor, this.maxSplitsPerSecond, this.maxOutstandingSplits, dynamicFilter, DeltaLakeSessionProperties.getDynamicFilteringWaitTimeout(session), deltaLakeTableHandle.isRecordScannedFiles());
        return new ClassLoaderSafeConnectorSplitSource((ConnectorSplitSource)splitSource, Thread.currentThread().getContextClassLoader());
    }

    private Stream<DeltaLakeSplit> getSplits(ConnectorTransactionHandle transaction, DeltaLakeTableHandle tableHandle, ConnectorSession session, Optional<DataSize> maxScannedFileSize, Set<ColumnHandle> columnsCoveredByDynamicFilter, Constraint constraint) {
        DeltaLakeMetastore metastore = this.getMetastore(session, transaction);
        String tableLocation = metastore.getTableLocation(tableHandle.getSchemaTableName(), session);
        List<AddFileEntry> validDataFiles = metastore.getValidDataFiles(tableHandle.getSchemaTableName(), session);
        TupleDomain<DeltaLakeColumnHandle> enforcedPartitionConstraint = tableHandle.getEnforcedPartitionConstraint();
        TupleDomain<DeltaLakeColumnHandle> nonPartitionConstraint = tableHandle.getNonPartitionConstraint();
        boolean splittable = tableHandle.getWriteType().isEmpty();
        AtomicInteger remainingInitialSplits = new AtomicInteger(this.maxInitialSplits);
        Optional filesModifiedAfter = tableHandle.getAnalyzeHandle().flatMap(AnalyzeHandle::getFilesModifiedAfter);
        Optional<Long> maxScannedFileSizeInBytes = maxScannedFileSize.map(DataSize::toBytes);
        Set predicatedColumnNames = (Set)Stream.concat(((Map)nonPartitionConstraint.getDomains().orElseThrow()).keySet().stream(), columnsCoveredByDynamicFilter.stream().map(DeltaLakeColumnHandle.class::cast)).map(column -> column.getName().toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
        List<ColumnMetadata> schema = DeltaLakeSchemaSupport.extractSchema(tableHandle.getMetadataEntry(), this.typeManager);
        List predicatedColumns = (List)schema.stream().filter(column -> predicatedColumnNames.contains(column.getName())).collect(ImmutableList.toImmutableList());
        return validDataFiles.stream().flatMap(addAction -> {
            if (tableHandle.getAnalyzeHandle().isPresent() && !tableHandle.getAnalyzeHandle().get().isInitialAnalyze() && !addAction.isDataChange()) {
                return Stream.empty();
            }
            if (filesModifiedAfter.isPresent() && addAction.getModificationTime() <= ((Instant)filesModifiedAfter.get()).toEpochMilli()) {
                return Stream.empty();
            }
            if (maxScannedFileSizeInBytes.isPresent() && addAction.getSize() > (Long)maxScannedFileSizeInBytes.get()) {
                return Stream.empty();
            }
            Map enforcedDomains = (Map)enforcedPartitionConstraint.getDomains().orElseThrow();
            if (!DeltaLakeSplitManager.partitionMatchesPredicate(addAction.getCanonicalPartitionValues(), enforcedDomains)) {
                return Stream.empty();
            }
            TupleDomain<DeltaLakeColumnHandle> statisticsPredicate = DeltaLakeMetadata.createStatisticsPredicate(addAction, predicatedColumns, tableHandle.getMetadataEntry().getCanonicalPartitionColumns());
            if (!nonPartitionConstraint.overlaps(statisticsPredicate)) {
                return Stream.empty();
            }
            if (constraint.predicate().isPresent()) {
                Map<String, Optional<String>> partitionValues = addAction.getCanonicalPartitionValues();
                Map deserializedValues = (Map)((Set)constraint.getPredicateColumns().orElseThrow()).stream().map(DeltaLakeColumnHandle.class::cast).filter(column -> partitionValues.containsKey(column.getName())).collect(ImmutableMap.toImmutableMap(Function.identity(), column -> new NullableValue(column.getType(), TransactionLogParser.deserializePartitionValue(column, (Optional)partitionValues.get(column.getName())))));
                if (!((Predicate)constraint.predicate().get()).test(deserializedValues)) {
                    return Stream.empty();
                }
            }
            return this.splitsForFile(session, (AddFileEntry)addAction, tableLocation, addAction.getCanonicalPartitionValues(), statisticsPredicate, splittable, remainingInitialSplits).stream();
        });
    }

    public static boolean partitionMatchesPredicate(Map<String, Optional<String>> partitionKeys, Map<DeltaLakeColumnHandle, Domain> domains) {
        for (Map.Entry<DeltaLakeColumnHandle, Domain> enforcedDomainsEntry : domains.entrySet()) {
            DeltaLakeColumnHandle partitionColumn = enforcedDomainsEntry.getKey();
            Domain partitionDomain = enforcedDomainsEntry.getValue();
            if (partitionDomain.includesNullableValue(TransactionLogParser.deserializePartitionValue(partitionColumn, partitionKeys.get(partitionColumn.getName())))) continue;
            return false;
        }
        return true;
    }

    private List<DeltaLakeSplit> splitsForFile(ConnectorSession session, AddFileEntry addFileEntry, String tableLocation, Map<String, Optional<String>> partitionKeys, TupleDomain<DeltaLakeColumnHandle> statisticsPredicate, boolean splittable, AtomicInteger remainingInitialSplits) {
        long splitSize;
        long fileSize = addFileEntry.getSize();
        String splitPath = DeltaLakeSplitManager.buildSplitPath(tableLocation, addFileEntry);
        if (!splittable) {
            return ImmutableList.of((Object)new DeltaLakeSplit(splitPath, 0L, fileSize, fileSize, addFileEntry.getModificationTime(), (List<HostAddress>)ImmutableList.of(), statisticsPredicate, partitionKeys));
        }
        ImmutableList.Builder splits = ImmutableList.builder();
        for (long currentOffset = 0L; currentOffset < fileSize; currentOffset += splitSize) {
            splitSize = remainingInitialSplits.get() > 0 && remainingInitialSplits.getAndDecrement() > 0 ? DeltaLakeSessionProperties.getMaxInitialSplitSize(session).toBytes() : DeltaLakeSessionProperties.getMaxSplitSize(session).toBytes();
            splitSize = Math.min(splitSize, fileSize - currentOffset);
            splits.add((Object)new DeltaLakeSplit(splitPath, currentOffset, splitSize, fileSize, addFileEntry.getModificationTime(), (List<HostAddress>)ImmutableList.of(), statisticsPredicate, partitionKeys));
        }
        return splits.build();
    }

    private static String buildSplitPath(String tableLocation, AddFileEntry addAction) {
        return tableLocation + "/" + URLDecoder.decode(addAction.getPath(), StandardCharsets.UTF_8);
    }

    private DeltaLakeMetastore getMetastore(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
        return this.metastoreProvider.apply(session, (HiveTransactionHandle)transactionHandle);
    }
}

