/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class DeltaLakeTableProperties {
    public static final String LOCATION_PROPERTY = "location";
    public static final String PARTITIONED_BY_PROPERTY = "partitioned_by";
    public static final String CHECKPOINT_INTERVAL_PROPERTY = "checkpoint_interval";
    public static final String ANALYZE_COLUMNS_PROPERTY = "$trino.analyze_columns";
    private final List<PropertyMetadata<?>> tableProperties = ImmutableList.builder().add((Object)PropertyMetadata.stringProperty((String)"location", (String)"File system location URI for the table", null, (boolean)false)).add((Object)new PropertyMetadata("partitioned_by", "Partition columns", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> ImmutableList.copyOf((Collection)((Collection)value).stream().map(name -> name.toLowerCase(Locale.ENGLISH)).collect(Collectors.toList())), value -> value)).add((Object)PropertyMetadata.longProperty((String)"checkpoint_interval", (String)"Checkpoint interval", null, (boolean)false)).build();

    @Inject
    public DeltaLakeTableProperties() {
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public static String getLocation(Map<String, Object> tableProperties) {
        return (String)tableProperties.get(LOCATION_PROPERTY);
    }

    public static List<String> getPartitionedBy(Map<String, Object> tableProperties) {
        List partitionedBy = (List)tableProperties.get(PARTITIONED_BY_PROPERTY);
        return partitionedBy == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)partitionedBy);
    }

    public static Optional<Long> getCheckpointInterval(Map<String, Object> tableProperties) {
        Optional<Long> checkpointInterval = Optional.ofNullable((Long)tableProperties.get(CHECKPOINT_INTERVAL_PROPERTY));
        checkpointInterval.ifPresent(value -> {
            if (value <= 0L) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s must be greater than 0", CHECKPOINT_INTERVAL_PROPERTY));
            }
        });
        return checkpointInterval;
    }

    public static Optional<Set<String>> getAnalyzeColumns(Map<String, Object> tableProperties) {
        return Optional.ofNullable((Set)tableProperties.get(ANALYZE_COLUMNS_PROPERTY));
    }
}

