/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.checkpoint;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.plugin.deltalake.DeltaHiveTypeTranslator;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionEntry;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointEntries;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointSchemaManager;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeJsonFileStatistics;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeParquetFileStatistics;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.HiveTypeName;
import io.trino.plugin.hive.RecordFileWriter;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.util.CompressionConfigUtil;
import io.trino.plugin.hive.util.ConfigurationUtils;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTimeZone;

public class CheckpointWriter {
    private static final int METADATA_BLOCK_CHANNEL = 0;
    private static final int PROTOCOL_BLOCK_CHANNEL = 1;
    private static final int TXN_BLOCK_CHANNEL = 2;
    private static final int ADD_BLOCK_CHANNEL = 3;
    private static final int REMOVE_BLOCK_CHANNEL = 4;
    private static final int CHANNELS_COUNT = 5;
    private final TypeManager typeManager;
    private final CheckpointSchemaManager checkpointSchemaManager;
    private final HdfsEnvironment hdfsEnvironment;

    public CheckpointWriter(TypeManager typeManager, CheckpointSchemaManager checkpointSchemaManager, HdfsEnvironment hdfsEnvironment) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.checkpointSchemaManager = Objects.requireNonNull(checkpointSchemaManager, "checkpointSchemaManager is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
    }

    public void write(ConnectorSession session, CheckpointEntries entries, Path targetPath) {
        RowType metadataEntryType = this.checkpointSchemaManager.getMetadataEntryType();
        RowType protocolEntryType = this.checkpointSchemaManager.getProtocolEntryType();
        RowType txnEntryType = this.checkpointSchemaManager.getTxnEntryType();
        RowType addEntryType = this.checkpointSchemaManager.getAddEntryType(entries.getMetadataEntry());
        RowType removeEntryType = this.checkpointSchemaManager.getRemoveEntryType();
        ImmutableList columnNames = ImmutableList.of((Object)"metaData", (Object)"protocol", (Object)"txn", (Object)"add", (Object)"remove");
        ImmutableList columnTypes = ImmutableList.of((Object)metadataEntryType, (Object)protocolEntryType, (Object)txnEntryType, (Object)addEntryType, (Object)removeEntryType);
        Properties schema = CheckpointWriter.buildSchemaProperties((List<String>)columnNames, (List<Type>)columnTypes);
        Configuration conf = this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session), targetPath);
        CompressionConfigUtil.configureCompression((Configuration)conf, (HiveCompressionCodec)HiveCompressionCodec.SNAPPY);
        JobConf jobConf = ConfigurationUtils.toJobConf((Configuration)conf);
        RecordFileWriter writer = new RecordFileWriter(targetPath, (List)columnNames, StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.PARQUET), schema, HiveStorageFormat.PARQUET.getEstimatedWriterMemoryUsage(), jobConf, this.typeManager, DateTimeZone.UTC, session);
        PageBuilder pageBuilder = new PageBuilder((List)columnTypes);
        this.writeMetadataEntry(pageBuilder, metadataEntryType, entries.getMetadataEntry());
        this.writeProtocolEntry(pageBuilder, protocolEntryType, entries.getProtocolEntry());
        for (TransactionEntry transactionEntry : entries.getTransactionEntries()) {
            this.writeTransactionEntry(pageBuilder, txnEntryType, transactionEntry);
        }
        for (AddFileEntry addFileEntry : entries.getAddFileEntries()) {
            this.writeAddFileEntry(pageBuilder, addEntryType, addFileEntry);
        }
        for (RemoveFileEntry removeFileEntry : entries.getRemoveFileEntries()) {
            this.writeRemoveFileEntry(pageBuilder, removeEntryType, removeFileEntry);
        }
        writer.appendRows(pageBuilder.build());
        writer.commit();
    }

    private static Properties buildSchemaProperties(List<String> columnNames, List<Type> columnTypes) {
        Properties schema = new Properties();
        schema.setProperty("columns", String.join((CharSequence)",", columnNames));
        schema.setProperty("columns.types", columnTypes.stream().map(DeltaHiveTypeTranslator::toHiveType).map(HiveType::getHiveTypeName).map(HiveTypeName::toString).collect(Collectors.joining(":")));
        return schema;
    }

    private void writeMetadataEntry(PageBuilder pageBuilder, RowType entryType, MetadataEntry metadataEntry) {
        pageBuilder.declarePosition();
        BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(0);
        BlockBuilder entryBlockBuilder = blockBuilder.beginBlockEntry();
        this.writeString(entryBlockBuilder, entryType, 0, "id", metadataEntry.getId());
        this.writeString(entryBlockBuilder, entryType, 1, "name", metadataEntry.getName());
        this.writeString(entryBlockBuilder, entryType, 2, "description", metadataEntry.getDescription());
        RowType formatType = this.getInternalRowType(entryType, 3, "format");
        BlockBuilder formatBlockBuilder = entryBlockBuilder.beginBlockEntry();
        this.writeString(formatBlockBuilder, formatType, 0, "provider", metadataEntry.getFormat().getProvider());
        this.writeStringMap(formatBlockBuilder, formatType, 1, "options", metadataEntry.getFormat().getOptions());
        entryBlockBuilder.closeEntry();
        this.writeString(entryBlockBuilder, entryType, 4, "schemaString", metadataEntry.getSchemaString());
        this.writeStringList(entryBlockBuilder, entryType, 5, "partitionColumns", metadataEntry.getOriginalPartitionColumns());
        this.writeStringMap(entryBlockBuilder, entryType, 6, "configuration", metadataEntry.getConfiguration());
        this.writeLong(entryBlockBuilder, entryType, 7, "createdTime", metadataEntry.getCreatedTime());
        blockBuilder.closeEntry();
        this.appendNullOtherBlocks(pageBuilder, 0);
    }

    private void writeProtocolEntry(PageBuilder pageBuilder, RowType entryType, ProtocolEntry protocolEntry) {
        pageBuilder.declarePosition();
        BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(1);
        BlockBuilder entryBlockBuilder = blockBuilder.beginBlockEntry();
        this.writeLong(entryBlockBuilder, entryType, 0, "minReaderVersion", Long.valueOf(protocolEntry.getMinReaderVersion()));
        this.writeLong(entryBlockBuilder, entryType, 1, "minWriterVersion", Long.valueOf(protocolEntry.getMinWriterVersion()));
        blockBuilder.closeEntry();
        this.appendNullOtherBlocks(pageBuilder, 1);
    }

    private void writeTransactionEntry(PageBuilder pageBuilder, RowType entryType, TransactionEntry transactionEntry) {
        pageBuilder.declarePosition();
        BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(2);
        BlockBuilder entryBlockBuilder = blockBuilder.beginBlockEntry();
        this.writeString(entryBlockBuilder, entryType, 0, "appId", transactionEntry.getAppId());
        this.writeLong(entryBlockBuilder, entryType, 1, "version", transactionEntry.getVersion());
        this.writeLong(entryBlockBuilder, entryType, 2, "lastUpdated", transactionEntry.getLastUpdated());
        blockBuilder.closeEntry();
        this.appendNullOtherBlocks(pageBuilder, 2);
    }

    private void writeAddFileEntry(PageBuilder pageBuilder, RowType entryType, AddFileEntry addFileEntry) {
        pageBuilder.declarePosition();
        BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(3);
        BlockBuilder entryBlockBuilder = blockBuilder.beginBlockEntry();
        this.writeString(entryBlockBuilder, entryType, 0, "path", addFileEntry.getPath());
        this.writeStringMap(entryBlockBuilder, entryType, 1, "partitionValues", addFileEntry.getPartitionValues());
        this.writeLong(entryBlockBuilder, entryType, 2, "size", addFileEntry.getSize());
        this.writeLong(entryBlockBuilder, entryType, 3, "modificationTime", addFileEntry.getModificationTime());
        this.writeBoolean(entryBlockBuilder, entryType, 4, "dataChange", addFileEntry.isDataChange());
        this.writeJsonStats(entryBlockBuilder, entryType, addFileEntry);
        this.writeParsedStats(entryBlockBuilder, entryType, addFileEntry);
        this.writeStringMap(entryBlockBuilder, entryType, 7, "tags", addFileEntry.getTags());
        blockBuilder.closeEntry();
        this.appendNullOtherBlocks(pageBuilder, 3);
    }

    private void writeJsonStats(BlockBuilder entryBlockBuilder, RowType entryType, AddFileEntry addFileEntry) {
        String statsJson = null;
        if (addFileEntry.getStats().isPresent() && addFileEntry.getStats().get() instanceof DeltaLakeJsonFileStatistics) {
            statsJson = addFileEntry.getStatsString().orElse(null);
        }
        this.writeString(entryBlockBuilder, entryType, 5, "stats", statsJson);
    }

    private void writeParsedStats(BlockBuilder entryBlockBuilder, RowType entryType, AddFileEntry addFileEntry) {
        RowType statsType = this.getInternalRowType(entryType, 6, "stats_parsed");
        if (addFileEntry.getStats().isEmpty() || !(addFileEntry.getStats().get() instanceof DeltaLakeParquetFileStatistics)) {
            entryBlockBuilder.appendNull();
            return;
        }
        DeltaLakeParquetFileStatistics stats = (DeltaLakeParquetFileStatistics)addFileEntry.getStats().get();
        BlockBuilder statsBlockBuilder = entryBlockBuilder.beginBlockEntry();
        this.writeLong(statsBlockBuilder, statsType, 0, "numRecords", stats.getNumRecords().orElse(null));
        this.writeMinMaxMapAsFields(statsBlockBuilder, statsType, 1, "minValues", stats.getMinValues());
        this.writeMinMaxMapAsFields(statsBlockBuilder, statsType, 2, "maxValues", stats.getMaxValues());
        this.writeObjectMapAsFields(statsBlockBuilder, statsType, 3, "nullCount", stats.getNullCount());
        entryBlockBuilder.closeEntry();
    }

    private void writeMinMaxMapAsFields(BlockBuilder blockBuilder, RowType type, int fieldId, String fieldName, Optional<Map<String, Object>> values) {
        RowType.Field valuesField = this.validateAndGetField(type, fieldId, fieldName);
        RowType valuesFieldType = (RowType)valuesField.getType();
        this.writeObjectMapAsFields(blockBuilder, type, fieldId, fieldName, this.preprocessMinMaxValues(valuesFieldType, values));
    }

    private void writeObjectMapAsFields(BlockBuilder blockBuilder, RowType type, int fieldId, String fieldName, Optional<Map<String, Object>> values) {
        RowType.Field valuesField = this.validateAndGetField(type, fieldId, fieldName);
        RowType valuesFieldType = (RowType)valuesField.getType();
        BlockBuilder fieldBlockBuilder = blockBuilder.beginBlockEntry();
        if (values.isEmpty()) {
            blockBuilder.appendNull();
        } else {
            for (RowType.Field valueField : valuesFieldType.getFields()) {
                Object value = values.get().get(valueField.getName().orElseThrow());
                if (valueField.getType() instanceof RowType) {
                    Block rowBlock = (Block)value;
                    Preconditions.checkState((rowBlock.getPositionCount() == 1 ? 1 : 0) != 0, (Object)"Invalid RowType statistics for writing Delta Lake checkpoint");
                    if (rowBlock.isNull(0)) {
                        fieldBlockBuilder.appendNull();
                        continue;
                    }
                    valueField.getType().appendTo(rowBlock, 0, fieldBlockBuilder);
                    continue;
                }
                TypeUtils.writeNativeValue((Type)valueField.getType(), (BlockBuilder)fieldBlockBuilder, (Object)value);
            }
        }
        blockBuilder.closeEntry();
    }

    private Optional<Map<String, Object>> preprocessMinMaxValues(RowType valuesType, Optional<Map<String, Object>> valuesOptional) {
        return valuesOptional.map(values -> {
            Map<String, Type> fieldTypes = valuesType.getFields().stream().collect(Collectors.toMap(field -> (String)field.getName().orElseThrow(), RowType.Field::getType));
            return values.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                Type type = (Type)fieldTypes.get(entry.getKey());
                Object value = entry.getValue();
                if (type instanceof TimestampType) {
                    value = Math.multiplyExact(DateTimeEncoding.unpackMillisUtc((long)((Long)value)), 1000);
                }
                return value;
            }));
        });
    }

    private void writeRemoveFileEntry(PageBuilder pageBuilder, RowType entryType, RemoveFileEntry removeFileEntry) {
        pageBuilder.declarePosition();
        BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(4);
        BlockBuilder entryBlockBuilder = blockBuilder.beginBlockEntry();
        this.writeString(entryBlockBuilder, entryType, 0, "path", removeFileEntry.getPath());
        this.writeLong(entryBlockBuilder, entryType, 1, "deletionTimestamp", removeFileEntry.getDeletionTimestamp());
        this.writeBoolean(entryBlockBuilder, entryType, 2, "dataChange", removeFileEntry.isDataChange());
        blockBuilder.closeEntry();
        this.appendNullOtherBlocks(pageBuilder, 4);
    }

    private void appendNullOtherBlocks(PageBuilder pageBuilder, int handledBlock) {
        for (int channel = 0; channel < 5; ++channel) {
            if (channel == handledBlock) continue;
            pageBuilder.getBlockBuilder(channel).appendNull();
        }
    }

    private void writeString(BlockBuilder blockBuilder, RowType type, int fieldId, String fieldName, @Nullable String value) {
        RowType.Field field = this.validateAndGetField(type, fieldId, fieldName);
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        field.getType().writeSlice(blockBuilder, Slices.utf8Slice((String)value));
    }

    private void writeLong(BlockBuilder blockBuilder, RowType type, int fieldId, String fieldName, @Nullable Long value) {
        RowType.Field field = this.validateAndGetField(type, fieldId, fieldName);
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        field.getType().writeLong(blockBuilder, value.longValue());
    }

    private void writeBoolean(BlockBuilder blockBuilder, RowType type, int fieldId, String fieldName, boolean value) {
        RowType.Field field = this.validateAndGetField(type, fieldId, fieldName);
        field.getType().writeBoolean(blockBuilder, value);
    }

    private void writeStringMap(BlockBuilder blockBuilder, RowType type, int fieldId, String fieldName, @Nullable Map<String, String> values) {
        RowType.Field field = this.validateAndGetField(type, fieldId, fieldName);
        Preconditions.checkArgument((boolean)(field.getType() instanceof MapType), (String)"Expected field %s/%s to by of MapType but got %s", (Object)fieldId, (Object)fieldName, (Object)field.getType());
        if (values == null) {
            blockBuilder.appendNull();
            return;
        }
        MapType mapType = (MapType)field.getType();
        BlockBuilder mapBuilder = blockBuilder.beginBlockEntry();
        for (Map.Entry<String, String> entry : values.entrySet()) {
            mapType.getKeyType().writeSlice(mapBuilder, Slices.utf8Slice((String)entry.getKey()));
            if (entry.getValue() == null) {
                mapBuilder.appendNull();
                continue;
            }
            mapType.getKeyType().writeSlice(mapBuilder, Slices.utf8Slice((String)entry.getValue()));
        }
        blockBuilder.closeEntry();
    }

    private void writeStringList(BlockBuilder blockBuilder, RowType type, int fieldId, String fieldName, @Nullable List<String> values) {
        RowType.Field field = this.validateAndGetField(type, fieldId, fieldName);
        Preconditions.checkArgument((boolean)(field.getType() instanceof ArrayType), (String)"Expected field %s/%s to by of ArrayType but got %s", (Object)fieldId, (Object)fieldName, (Object)field.getType());
        if (values == null) {
            blockBuilder.appendNull();
            return;
        }
        ArrayType arrayType = (ArrayType)field.getType();
        BlockBuilder mapBuilder = blockBuilder.beginBlockEntry();
        for (String value : values) {
            if (value == null) {
                mapBuilder.appendNull();
                continue;
            }
            arrayType.getElementType().writeSlice(mapBuilder, Slices.utf8Slice((String)value));
        }
        blockBuilder.closeEntry();
    }

    private RowType getInternalRowType(RowType type, int fieldId, String fieldName) {
        RowType.Field field = this.validateAndGetField(type, fieldId, fieldName);
        Preconditions.checkArgument((boolean)(field.getType() instanceof RowType), (String)"Expected field %s/%s to by of RowType but got %s", (Object)fieldId, (Object)fieldName, (Object)field.getType());
        return (RowType)field.getType();
    }

    private RowType.Field validateAndGetField(RowType type, int fieldId, String fieldName) {
        Preconditions.checkArgument((type.getFields().size() > fieldId ? 1 : 0) != 0, (String)"Field %s/%s not found for type %s", (Object)fieldId, (Object)fieldName, (Object)type);
        RowType.Field field = (RowType.Field)type.getFields().get(fieldId);
        Preconditions.checkArgument((boolean)((String)field.getName().orElseThrow()).equals(fieldName), (String)"Expected %s for field %s but got %s for type %s", (Object)fieldName, (Object)fieldId, (Object)field.getName(), (Object)type);
        return field;
    }
}

