/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.writer;

import io.trino.plugin.deltalake.transactionlog.writer.TransactionConflictException;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogSynchronizer;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class AzureTransactionLogSynchronizer
implements TransactionLogSynchronizer {
    private final HdfsEnvironment hdfsEnvironment;

    @Inject
    public AzureTransactionLogSynchronizer(HdfsEnvironment hdfsEnvironment) {
        this.hdfsEnvironment = hdfsEnvironment;
    }

    @Override
    public void write(ConnectorSession session, String clusterId, Path newLogEntryPath, byte[] entryContents) {
        String tmpFileName = newLogEntryPath.getName() + "." + UUID.randomUUID() + ".tmp";
        Path tmpFilePath = new Path(newLogEntryPath.getParent(), tmpFileName);
        FileSystem fs = null;
        try {
            fs = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), newLogEntryPath);
            try (FSDataOutputStream outputStream = fs.create(tmpFilePath, false);){
                outputStream.write(entryContents);
            }
            if (!fs.rename(tmpFilePath, newLogEntryPath)) {
                fs.delete(tmpFilePath, false);
                throw new TransactionConflictException("Conflict detected while writing Transaction Log entry to ADLS");
            }
        }
        catch (IOException e) {
            block13: {
                try {
                    if (fs != null && fs.exists(tmpFilePath)) {
                        fs.delete(tmpFilePath, false);
                    }
                }
                catch (Exception cleanupException) {
                    if (e == cleanupException) break block13;
                    e.addSuppressed(cleanupException);
                }
            }
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean isUnsafe() {
        return false;
    }
}

