/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.writer;

import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogSynchronizer;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class NoIsolationSynchronizer
implements TransactionLogSynchronizer {
    private final HdfsEnvironment hdfsEnvironment;

    @Inject
    public NoIsolationSynchronizer(HdfsEnvironment hdfsEnvironment) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
    }

    @Override
    public void write(ConnectorSession session, String clusterId, Path newLogEntryPath, byte[] entryContents) throws UncheckedIOException {
        try {
            FileSystem fs = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), newLogEntryPath);
            try (FSDataOutputStream outputStream = fs.create(newLogEntryPath, false);){
                outputStream.write(entryContents);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean isUnsafe() {
        return true;
    }
}

