/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.FieldDereference;
import io.trino.spi.expression.Variable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class HiveApplyProjectionUtil {
    private HiveApplyProjectionUtil() {
    }

    public static List<ConnectorExpression> extractSupportedProjectedColumns(ConnectorExpression expression) {
        Objects.requireNonNull(expression, "expression is null");
        ImmutableList.Builder supportedSubExpressions = ImmutableList.builder();
        HiveApplyProjectionUtil.fillSupportedProjectedColumns(expression, (ImmutableList.Builder<ConnectorExpression>)supportedSubExpressions);
        return supportedSubExpressions.build();
    }

    private static void fillSupportedProjectedColumns(ConnectorExpression expression, ImmutableList.Builder<ConnectorExpression> supportedSubExpressions) {
        if (HiveApplyProjectionUtil.isPushDownSupported(expression)) {
            supportedSubExpressions.add((Object)expression);
            return;
        }
        for (ConnectorExpression child : expression.getChildren()) {
            HiveApplyProjectionUtil.fillSupportedProjectedColumns(child, supportedSubExpressions);
        }
    }

    @VisibleForTesting
    static boolean isPushDownSupported(ConnectorExpression expression) {
        return expression instanceof Variable || expression instanceof FieldDereference && HiveApplyProjectionUtil.isPushDownSupported(((FieldDereference)expression).getTarget());
    }

    public static ProjectedColumnRepresentation createProjectedColumnRepresentation(ConnectorExpression expression) {
        ImmutableList.Builder ordinals;
        block1: {
            ordinals = ImmutableList.builder();
            while (true) {
                if (expression instanceof Variable) break block1;
                if (!(expression instanceof FieldDereference)) break;
                FieldDereference dereference = (FieldDereference)expression;
                ordinals.add((Object)dereference.getField());
                expression = dereference.getTarget();
            }
            throw new IllegalArgumentException("expression is not a valid dereference chain");
        }
        Variable target = (Variable)expression;
        return new ProjectedColumnRepresentation(target, (List<Integer>)ordinals.build().reverse());
    }

    public static ConnectorExpression replaceWithNewVariables(ConnectorExpression expression, Map<ConnectorExpression, Variable> expressionToVariableMappings) {
        if (expressionToVariableMappings.containsKey(expression)) {
            return (ConnectorExpression)expressionToVariableMappings.get(expression);
        }
        if (expression instanceof Constant || expression instanceof Variable) {
            return expression;
        }
        if (expression instanceof FieldDereference) {
            ConnectorExpression newTarget = HiveApplyProjectionUtil.replaceWithNewVariables(((FieldDereference)expression).getTarget(), expressionToVariableMappings);
            return new FieldDereference(expression.getType(), newTarget, ((FieldDereference)expression).getField());
        }
        if (expression instanceof Call) {
            Call call = (Call)expression;
            return new Call(call.getType(), call.getFunctionName(), (List)call.getArguments().stream().map(argument -> HiveApplyProjectionUtil.replaceWithNewVariables(argument, expressionToVariableMappings)).collect(ImmutableList.toImmutableList()));
        }
        throw new UnsupportedOperationException("Unsupported expression: " + expression);
    }

    public static Optional<String> find(Map<String, ColumnHandle> assignments, ProjectedColumnRepresentation projectedColumn) {
        HiveColumnHandle variableColumn = (HiveColumnHandle)assignments.get(projectedColumn.getVariable().getName());
        if (variableColumn == null) {
            return Optional.empty();
        }
        String baseColumnName = variableColumn.getBaseColumnName();
        List variableColumnIndices = variableColumn.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of());
        ImmutableList projectionIndices = ImmutableList.builder().addAll((Iterable)variableColumnIndices).addAll(projectedColumn.getDereferenceIndices()).build();
        for (Map.Entry<String, ColumnHandle> entry : assignments.entrySet()) {
            HiveColumnHandle column = (HiveColumnHandle)entry.getValue();
            if (!column.getBaseColumnName().equals(baseColumnName) || !column.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of()).equals(projectionIndices)) continue;
            return Optional.of(entry.getKey());
        }
        return Optional.empty();
    }

    public static class ProjectedColumnRepresentation {
        private final Variable variable;
        private final List<Integer> dereferenceIndices;

        public ProjectedColumnRepresentation(Variable variable, List<Integer> dereferenceIndices) {
            this.variable = Objects.requireNonNull(variable, "variable is null");
            this.dereferenceIndices = ImmutableList.copyOf((Collection)Objects.requireNonNull(dereferenceIndices, "dereferenceIndices is null"));
        }

        public Variable getVariable() {
            return this.variable;
        }

        public List<Integer> getDereferenceIndices() {
            return this.dereferenceIndices;
        }

        public boolean isVariable() {
            return this.dereferenceIndices.isEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectedColumnRepresentation that = (ProjectedColumnRepresentation)obj;
            return Objects.equals(this.variable, that.variable) && Objects.equals(this.dereferenceIndices, that.dereferenceIndices);
        }

        public int hashCode() {
            return Objects.hash(this.variable, this.dereferenceIndices);
        }
    }
}

