/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.trino.plugin.hive.BackgroundHiveSplitLoader;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveBucketHandle;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveNotReadableException;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HivePartitionManager;
import io.trino.plugin.hive.HivePartitionMetadata;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveSplitSource;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.HiveTransactionManager;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.HiveTypeName;
import io.trino.plugin.hive.NamenodeStats;
import io.trino.plugin.hive.TableToPartitionMapping;
import io.trino.plugin.hive.TransactionalMetadata;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.metastore.SortingColumn;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.plugin.hive.util.HiveCoercionPolicy;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.VersionEmbedder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.type.TypeManager;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class HiveSplitManager
implements ConnectorSplitManager {
    public static final String PRESTO_OFFLINE = "presto_offline";
    public static final String OBJECT_NOT_READABLE = "object_not_readable";
    private final HiveTransactionManager transactionManager;
    private final HivePartitionManager partitionManager;
    private final NamenodeStats namenodeStats;
    private final HdfsEnvironment hdfsEnvironment;
    private final Executor executor;
    private final int maxOutstandingSplits;
    private final DataSize maxOutstandingSplitsSize;
    private final int minPartitionBatchSize;
    private final int maxPartitionBatchSize;
    private final int maxInitialSplits;
    private final int splitLoaderConcurrency;
    private final int maxSplitsPerSecond;
    private final boolean recursiveDfsWalkerEnabled;
    private final CounterStat highMemorySplitSourceCounter;
    private final TypeManager typeManager;

    @Inject
    public HiveSplitManager(HiveConfig hiveConfig, HiveTransactionManager transactionManager, HivePartitionManager partitionManager, NamenodeStats namenodeStats, HdfsEnvironment hdfsEnvironment, ExecutorService executorService, VersionEmbedder versionEmbedder, TypeManager typeManager) {
        this(transactionManager, partitionManager, namenodeStats, hdfsEnvironment, versionEmbedder.embedVersion((Executor)new BoundedExecutor((Executor)executorService, hiveConfig.getMaxSplitIteratorThreads())), new CounterStat(), hiveConfig.getMaxOutstandingSplits(), hiveConfig.getMaxOutstandingSplitsSize(), hiveConfig.getMinPartitionBatchSize(), hiveConfig.getMaxPartitionBatchSize(), hiveConfig.getMaxInitialSplits(), hiveConfig.getSplitLoaderConcurrency(), hiveConfig.getMaxSplitsPerSecond(), hiveConfig.getRecursiveDirWalkerEnabled(), typeManager);
    }

    public HiveSplitManager(HiveTransactionManager transactionManager, HivePartitionManager partitionManager, NamenodeStats namenodeStats, HdfsEnvironment hdfsEnvironment, Executor executor, CounterStat highMemorySplitSourceCounter, int maxOutstandingSplits, DataSize maxOutstandingSplitsSize, int minPartitionBatchSize, int maxPartitionBatchSize, int maxInitialSplits, int splitLoaderConcurrency, @Nullable Integer maxSplitsPerSecond, boolean recursiveDfsWalkerEnabled, TypeManager typeManager) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.namenodeStats = Objects.requireNonNull(namenodeStats, "namenodeStats is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.executor = new ErrorCodedExecutor(executor);
        this.highMemorySplitSourceCounter = Objects.requireNonNull(highMemorySplitSourceCounter, "highMemorySplitSourceCounter is null");
        Preconditions.checkArgument((maxOutstandingSplits >= 1 ? 1 : 0) != 0, (Object)"maxOutstandingSplits must be at least 1");
        this.maxOutstandingSplits = maxOutstandingSplits;
        this.maxOutstandingSplitsSize = maxOutstandingSplitsSize;
        this.minPartitionBatchSize = minPartitionBatchSize;
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        this.maxInitialSplits = maxInitialSplits;
        this.splitLoaderConcurrency = splitLoaderConcurrency;
        this.maxSplitsPerSecond = (Integer)MoreObjects.firstNonNull((Object)maxSplitsPerSecond, (Object)Integer.MAX_VALUE);
        this.recursiveDfsWalkerEnabled = recursiveDfsWalkerEnabled;
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy, DynamicFilter dynamicFilter) {
        HiveSplitSource splitSource;
        HiveTableHandle hiveTable = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTable.getSchemaTableName();
        TransactionalMetadata transactionalMetadata = this.transactionManager.get(transaction, session.getIdentity());
        SemiTransactionalHiveMetastore metastore = transactionalMetadata.getMetastore();
        Table table = metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        String tableNotReadable = table.getParameters().get(OBJECT_NOT_READABLE);
        if (!Strings.isNullOrEmpty((String)tableNotReadable)) {
            throw new HiveNotReadableException(tableName, Optional.empty(), tableNotReadable);
        }
        List partitions = this.partitionManager.getOrLoadPartitions(metastore, hiveTable);
        if (partitions.isEmpty()) {
            if (hiveTable.isRecordScannedFiles()) {
                return new FixedSplitSource((Iterable)ImmutableList.of(), (List)ImmutableList.of());
            }
            return new FixedSplitSource((Iterable)ImmutableList.of());
        }
        Optional<HiveBucketing.HiveBucketFilter> bucketFilter = hiveTable.getBucketFilter();
        Optional<HiveBucketHandle> bucketHandle = hiveTable.getBucketHandle();
        if (splitSchedulingStrategy == ConnectorSplitManager.SplitSchedulingStrategy.GROUPED_SCHEDULING && bucketHandle.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "SchedulingPolicy is bucketed, but BucketHandle is not present");
        }
        partitions = Ordering.natural().onResultOf(HivePartition::getPartitionId).reverse().sortedCopy(partitions);
        if (bucketHandle.isPresent() && bucketHandle.get().getReadBucketCount() > bucketHandle.get().getTableBucketCount()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "readBucketCount (%s) is greater than the tableBucketCount (%s) which generally points to an issue in plan generation");
        }
        Iterable<HivePartitionMetadata> hivePartitions = this.getPartitionMetadata(session, metastore, table, tableName, partitions, bucketHandle.map(HiveBucketHandle::toTableBucketProperty));
        int concurrency = AcidUtils.isTransactionalTable(table.getParameters()) ? this.splitLoaderConcurrency : Math.min(this.splitLoaderConcurrency, partitions.size());
        BackgroundHiveSplitLoader hiveSplitLoader = new BackgroundHiveSplitLoader(table, hiveTable.getTransaction(), hivePartitions, hiveTable.getCompactEffectivePredicate(), dynamicFilter, HiveSessionProperties.getDynamicFilteringWaitTimeout(session), this.typeManager, BackgroundHiveSplitLoader.BucketSplitInfo.createBucketSplitInfo(bucketHandle, bucketFilter), session, this.hdfsEnvironment, this.namenodeStats, transactionalMetadata.getDirectoryLister(), this.executor, concurrency, this.recursiveDfsWalkerEnabled, !hiveTable.getPartitionColumns().isEmpty() && HiveSessionProperties.isIgnoreAbsentPartitions(session), HiveSessionProperties.isOptimizeSymlinkListing(session), metastore.getValidWriteIds(session, hiveTable).map(validTxnWriteIdList -> validTxnWriteIdList.getTableValidWriteIdList(table.getDatabaseName() + "." + table.getTableName())), hiveTable.getMaxScannedFileSize());
        switch (splitSchedulingStrategy) {
            case UNGROUPED_SCHEDULING: {
                splitSource = HiveSplitSource.allAtOnce(session, table.getDatabaseName(), table.getTableName(), this.maxInitialSplits, this.maxOutstandingSplits, this.maxOutstandingSplitsSize, this.maxSplitsPerSecond, hiveSplitLoader, this.executor, this.highMemorySplitSourceCounter, hiveTable.isRecordScannedFiles());
                break;
            }
            case GROUPED_SCHEDULING: {
                splitSource = HiveSplitSource.bucketed(session, table.getDatabaseName(), table.getTableName(), this.maxInitialSplits, this.maxOutstandingSplits, this.maxOutstandingSplitsSize, this.maxSplitsPerSecond, hiveSplitLoader, this.executor, this.highMemorySplitSourceCounter, hiveTable.isRecordScannedFiles());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown splitSchedulingStrategy: " + splitSchedulingStrategy);
            }
        }
        hiveSplitLoader.start(splitSource);
        return splitSource;
    }

    @Managed
    @Nested
    public CounterStat getHighMemorySplitSource() {
        return this.highMemorySplitSourceCounter;
    }

    private Iterable<HivePartitionMetadata> getPartitionMetadata(ConnectorSession session, SemiTransactionalHiveMetastore metastore, Table table, SchemaTableName tableName, List<HivePartition> hivePartitions, Optional<HiveBucketProperty> bucketProperty) {
        HivePartition firstPartition;
        if (hivePartitions.isEmpty()) {
            return ImmutableList.of();
        }
        if (hivePartitions.size() == 1 && (firstPartition = (HivePartition)Iterables.getOnlyElement(hivePartitions)).getPartitionId().equals("<UNPARTITIONED>")) {
            return ImmutableList.of((Object)new HivePartitionMetadata(firstPartition, Optional.empty(), TableToPartitionMapping.empty()));
        }
        Optional<HiveStorageFormat> storageFormat = HiveStorageFormat.getHiveStorageFormat(table.getStorage().getStorageFormat());
        Iterable<List<HivePartition>> partitionNameBatches = HiveSplitManager.partitionExponentially(hivePartitions, this.minPartitionBatchSize, this.maxPartitionBatchSize);
        Iterable partitionBatches = Iterables.transform(partitionNameBatches, partitionBatch -> {
            Map<String, Optional<Partition>> batch = metastore.getPartitionsByNames(tableName.getSchemaName(), tableName.getTableName(), Lists.transform((List)partitionBatch, HivePartition::getPartitionId));
            ImmutableMap.Builder partitionBuilder = ImmutableMap.builder();
            for (Map.Entry<String, Optional<Partition>> entry : batch.entrySet()) {
                if (entry.getValue().isEmpty()) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_DROPPED_DURING_QUERY, "Partition no longer exists: " + entry.getKey());
                }
                partitionBuilder.put((Object)entry.getKey(), (Object)entry.getValue().get());
            }
            ImmutableMap partitions = partitionBuilder.buildOrThrow();
            if (partitionBatch.size() != partitions.size()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Expected %s partitions but found %s", partitionBatch.size(), partitions.size()));
            }
            ImmutableList.Builder results = ImmutableList.builder();
            for (HivePartition hivePartition : partitionBatch) {
                Partition partition = (Partition)partitions.get(hivePartition.getPartitionId());
                if (partition == null) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Partition not loaded: " + hivePartition);
                }
                String partName = MetastoreUtil.makePartitionName(table, partition);
                MetastoreUtil.verifyOnline(tableName, Optional.of(partName), MetastoreUtil.getProtectMode(partition), partition.getParameters());
                String partitionNotReadable = partition.getParameters().get(OBJECT_NOT_READABLE);
                if (!Strings.isNullOrEmpty((String)partitionNotReadable)) {
                    throw new HiveNotReadableException(tableName, Optional.of(partName), partitionNotReadable);
                }
                List<Column> tableColumns = table.getDataColumns();
                List<Column> partitionColumns = partition.getColumns();
                if (tableColumns == null || partitionColumns == null) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Table '%s' or partition '%s' has null columns", tableName, partName));
                }
                TableToPartitionMapping tableToPartitionMapping = this.getTableToPartitionMapping(session, storageFormat, tableName, partName, tableColumns, partitionColumns);
                if (bucketProperty.isPresent()) {
                    List<SortingColumn> partitionSortedColumns;
                    List<SortingColumn> tableSortedColumns;
                    List<String> partitionBucketColumns;
                    Optional<HiveBucketProperty> partitionBucketProperty = partition.getStorage().getBucketProperty();
                    if (partitionBucketProperty.isEmpty()) {
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("Hive table (%s) is bucketed but partition (%s) is not bucketed", hivePartition.getTableName(), hivePartition.getPartitionId()));
                    }
                    int tableBucketCount = ((HiveBucketProperty)bucketProperty.get()).getBucketCount();
                    int partitionBucketCount = partitionBucketProperty.get().getBucketCount();
                    List<String> tableBucketColumns = ((HiveBucketProperty)bucketProperty.get()).getBucketedBy();
                    if (!tableBucketColumns.equals(partitionBucketColumns = partitionBucketProperty.get().getBucketedBy()) || !HiveSplitManager.isBucketCountCompatible(tableBucketCount, partitionBucketCount)) {
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("Hive table (%s) bucketing (columns=%s, buckets=%s) is not compatible with partition (%s) bucketing (columns=%s, buckets=%s)", hivePartition.getTableName(), tableBucketColumns, tableBucketCount, hivePartition.getPartitionId(), partitionBucketColumns, partitionBucketCount));
                    }
                    if (HiveSessionProperties.isPropagateTableScanSortingProperties(session) && !HiveSplitManager.isSortingCompatible(tableSortedColumns = ((HiveBucketProperty)bucketProperty.get()).getSortedBy(), partitionSortedColumns = partitionBucketProperty.get().getSortedBy())) {
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("Hive table (%s) sorting by %s is not compatible with partition (%s) sorting by %s. This restriction can be avoided by disabling propagate_table_scan_sorting_properties.", hivePartition.getTableName(), tableSortedColumns.stream().map(HiveUtil::sortingColumnToString).collect(ImmutableList.toImmutableList()), hivePartition.getPartitionId(), partitionSortedColumns.stream().map(HiveUtil::sortingColumnToString).collect(ImmutableList.toImmutableList())));
                    }
                }
                results.add((Object)new HivePartitionMetadata(hivePartition, Optional.of(partition), tableToPartitionMapping));
            }
            return results.build();
        });
        return Iterables.concat((Iterable)partitionBatches);
    }

    private TableToPartitionMapping getTableToPartitionMapping(ConnectorSession session, Optional<HiveStorageFormat> storageFormat, SchemaTableName tableName, String partName, List<Column> tableColumns, List<Column> partitionColumns) {
        if (storageFormat.isPresent() && HiveSplitManager.isPartitionUsesColumnNames(session, storageFormat.get())) {
            return this.getTableToPartitionMappingByColumnNames(tableName, partName, tableColumns, partitionColumns);
        }
        ImmutableMap.Builder columnCoercions = ImmutableMap.builder();
        for (int i = 0; i < Math.min(partitionColumns.size(), tableColumns.size()); ++i) {
            HiveType partitionType;
            HiveType tableType = tableColumns.get(i).getType();
            if (tableType.equals(partitionType = partitionColumns.get(i).getType())) continue;
            if (!HiveCoercionPolicy.canCoerce(this.typeManager, partitionType, tableType)) {
                throw this.tablePartitionColumnMismatchException(tableName, partName, tableColumns.get(i).getName(), tableType, partitionColumns.get(i).getName(), partitionType);
            }
            columnCoercions.put((Object)i, (Object)partitionType.getHiveTypeName());
        }
        return TableToPartitionMapping.mapColumnsByIndex((Map<Integer, HiveTypeName>)columnCoercions.buildOrThrow());
    }

    private static boolean isPartitionUsesColumnNames(ConnectorSession session, HiveStorageFormat storageFormat) {
        switch (storageFormat) {
            case AVRO: {
                return true;
            }
            case JSON: {
                return true;
            }
            case ORC: {
                return HiveSessionProperties.isUseOrcColumnNames(session);
            }
            case PARQUET: {
                return HiveSessionProperties.isUseParquetColumnNames(session);
            }
        }
        return false;
    }

    private TableToPartitionMapping getTableToPartitionMappingByColumnNames(SchemaTableName tableName, String partName, List<Column> tableColumns, List<Column> partitionColumns) {
        ImmutableMap.Builder partitionColumnIndexesBuilder = ImmutableMap.builder();
        for (int i = 0; i < partitionColumns.size(); ++i) {
            partitionColumnIndexesBuilder.put((Object)partitionColumns.get(i).getName().toLowerCase(Locale.ENGLISH), (Object)i);
        }
        ImmutableMap partitionColumnsByIndex = partitionColumnIndexesBuilder.buildOrThrow();
        ImmutableMap.Builder columnCoercions = ImmutableMap.builder();
        ImmutableMap.Builder tableToPartitionColumns = ImmutableMap.builder();
        for (int tableColumnIndex = 0; tableColumnIndex < tableColumns.size(); ++tableColumnIndex) {
            Column tableColumn = tableColumns.get(tableColumnIndex);
            HiveType tableType = tableColumn.getType();
            Integer partitionColumnIndex = (Integer)partitionColumnsByIndex.get(tableColumn.getName().toLowerCase(Locale.ENGLISH));
            if (partitionColumnIndex == null) continue;
            tableToPartitionColumns.put((Object)tableColumnIndex, (Object)partitionColumnIndex);
            Column partitionColumn = partitionColumns.get(partitionColumnIndex);
            HiveType partitionType = partitionColumn.getType();
            if (tableType.equals(partitionType)) continue;
            if (!HiveCoercionPolicy.canCoerce(this.typeManager, partitionType, tableType)) {
                throw this.tablePartitionColumnMismatchException(tableName, partName, tableColumn.getName(), tableType, partitionColumn.getName(), partitionType);
            }
            columnCoercions.put((Object)partitionColumnIndex, (Object)partitionType.getHiveTypeName());
        }
        return new TableToPartitionMapping(Optional.of(tableToPartitionColumns.buildOrThrow()), (Map<Integer, HiveTypeName>)columnCoercions.buildOrThrow());
    }

    private TrinoException tablePartitionColumnMismatchException(SchemaTableName tableName, String partName, String tableColumnName, HiveType tableType, String partitionColumnName, HiveType partitionType) {
        return new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("There is a mismatch between the table and partition schemas. The types are incompatible and cannot be coerced. The column '%s' in table '%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", tableColumnName, tableName, tableType, partName, partitionColumnName, partitionType));
    }

    static boolean isBucketCountCompatible(int tableBucketCount, int partitionBucketCount) {
        Preconditions.checkArgument((tableBucketCount > 0 && partitionBucketCount > 0 ? 1 : 0) != 0);
        int larger = Math.max(tableBucketCount, partitionBucketCount);
        int smaller = Math.min(tableBucketCount, partitionBucketCount);
        if (larger % smaller != 0) {
            return false;
        }
        return Integer.bitCount(larger / smaller) == 1;
    }

    private static boolean isSortingCompatible(List<SortingColumn> tableSortedColumns, List<SortingColumn> partitionSortedColumns) {
        if (tableSortedColumns.size() > partitionSortedColumns.size()) {
            return false;
        }
        for (int i = 0; i < tableSortedColumns.size(); ++i) {
            SortingColumn partitionSortingColumn;
            SortingColumn tableSortingColumn = tableSortedColumns.get(i);
            if (tableSortingColumn.equals(partitionSortingColumn = partitionSortedColumns.get(i))) continue;
            return false;
        }
        return true;
    }

    private static <T> Iterable<List<T>> partitionExponentially(final List<T> values, final int minBatchSize, final int maxBatchSize) {
        return () -> new AbstractIterator<List<T>>(){
            private int currentSize;
            private final Iterator iterator;
            {
                this.currentSize = minBatchSize;
                this.iterator = values.iterator();
            }

            protected List<T> computeNext() {
                if (!this.iterator.hasNext()) {
                    return (List)this.endOfData();
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int count = 0; this.iterator.hasNext() && count < this.currentSize; ++count) {
                    builder.add(this.iterator.next());
                }
                this.currentSize = Math.min(maxBatchSize, this.currentSize * 2);
                return builder.build();
            }
        };
    }

    private static class ErrorCodedExecutor
    implements Executor {
        private final Executor delegate;

        private ErrorCodedExecutor(Executor delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void execute(Runnable command) {
            try {
                this.delegate.execute(command);
            }
            catch (RejectedExecutionException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SERVER_SHUTTING_DOWN, "Server is shutting down", (Throwable)e);
            }
        }
    }
}

