/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.trino.plugin.hive.metastore.DecoratedHiveMetastoreModule;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.MetastoreTypeConfig;
import io.trino.plugin.hive.metastore.RawHiveMetastoreFactory;
import io.trino.plugin.hive.metastore.file.FileMetastoreModule;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreModule;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreModule;
import java.util.Optional;

public class HiveMetastoreModule
extends AbstractConfigurationAwareModule {
    private final Optional<HiveMetastore> metastore;

    public HiveMetastoreModule(Optional<HiveMetastore> metastore) {
        this.metastore = metastore;
    }

    protected void setup(Binder binder) {
        if (this.metastore.isPresent()) {
            binder.bind(HiveMetastoreFactory.class).annotatedWith(RawHiveMetastoreFactory.class).toInstance((Object)HiveMetastoreFactory.ofInstance(this.metastore.get()));
        } else {
            this.bindMetastoreModule("thrift", (Module)new ThriftMetastoreModule());
            this.bindMetastoreModule("file", new FileMetastoreModule());
            this.bindMetastoreModule("glue", (Module)new GlueMetastoreModule());
            this.bindMetastoreModule("alluxio", HiveMetastoreModule.deferredModule("io.trino.plugin.hive.metastore.alluxio.AlluxioMetastoreModule"));
        }
        this.install((Module)new DecoratedHiveMetastoreModule());
    }

    private void bindMetastoreModule(String name, Module module) {
        this.install(ConditionalModule.conditionalModule(MetastoreTypeConfig.class, metastore -> name.equalsIgnoreCase(metastore.getMetastoreType()), (Module)module));
    }

    private static Module deferredModule(final String moduleClassName) {
        return new AbstractConfigurationAwareModule(){

            protected void setup(Binder binder) {
                try {
                    this.install(Class.forName(moduleClassName).asSubclass(Module.class).getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("Problem loading module class: " + moduleClassName, e);
                }
            }
        };
    }
}

