/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.OrcRecordReader;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.OrcType;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveUpdateProcessor;
import io.trino.plugin.hive.orc.OrcDeletedRows;
import io.trino.plugin.hive.orc.OrcFileWriter;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.LazyBlockLoader;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class OrcPageSource
implements ConnectorPageSource {
    private static final Block ORIGINAL_FILE_TRANSACTION_ID_BLOCK = Utils.nativeValueToBlock((Type)BigintType.BIGINT, (Object)0L);
    private final OrcRecordReader recordReader;
    private final List<ColumnAdaptation> columnAdaptations;
    private final OrcDataSource orcDataSource;
    private final Optional<OrcDeletedRows> deletedRows;
    private boolean closed;
    private final AggregatedMemoryContext memoryContext;
    private final LocalMemoryContext localMemoryContext;
    private final FileFormatDataSourceStats stats;
    private final Optional<Long> originalFileRowId;
    private long completedPositions;
    private Optional<Page> outstandingPage = Optional.empty();

    public OrcPageSource(OrcRecordReader recordReader, List<ColumnAdaptation> columnAdaptations, OrcDataSource orcDataSource, Optional<OrcDeletedRows> deletedRows, Optional<Long> originalFileRowId, AggregatedMemoryContext memoryContext, FileFormatDataSourceStats stats) {
        this.recordReader = Objects.requireNonNull(recordReader, "recordReader is null");
        this.columnAdaptations = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnAdaptations, "columnAdaptations is null"));
        this.orcDataSource = Objects.requireNonNull(orcDataSource, "orcDataSource is null");
        this.deletedRows = Objects.requireNonNull(deletedRows, "deletedRows is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.memoryContext = Objects.requireNonNull(memoryContext, "memoryContext is null");
        this.localMemoryContext = memoryContext.newLocalMemoryContext(OrcPageSource.class.getSimpleName());
        this.originalFileRowId = Objects.requireNonNull(originalFileRowId, "originalFileRowId is null");
    }

    public long getCompletedBytes() {
        return this.orcDataSource.getReadBytes();
    }

    public OptionalLong getCompletedPositions() {
        return OptionalLong.of(this.completedPositions);
    }

    public long getReadTimeNanos() {
        return this.orcDataSource.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public ColumnMetadata<OrcType> getColumnTypes() {
        return this.recordReader.getColumnTypes();
    }

    public Page getNextPage() {
        OptionalLong startRowId;
        Page page;
        try {
            if (this.outstandingPage.isPresent()) {
                page = this.outstandingPage.get();
                this.outstandingPage = Optional.empty();
                this.localMemoryContext.setBytes(0L);
            } else {
                page = this.recordReader.nextPage();
            }
        }
        catch (IOException | RuntimeException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw OrcPageSource.handleException(this.orcDataSource.getId(), e);
        }
        if (page == null) {
            this.close();
            return null;
        }
        this.completedPositions += (long)page.getPositionCount();
        OptionalLong optionalLong = startRowId = this.originalFileRowId.isPresent() ? OptionalLong.of(this.originalFileRowId.get() + this.recordReader.getFilePosition()) : OptionalLong.empty();
        if (this.deletedRows.isPresent()) {
            boolean deletedRowsYielded;
            boolean bl = deletedRowsYielded = !this.deletedRows.get().loadOrYield();
            if (deletedRowsYielded) {
                this.outstandingPage = Optional.of(page);
                this.localMemoryContext.setBytes(page.getRetainedSizeInBytes());
                return null;
            }
        }
        OrcDeletedRows.MaskDeletedRowsFunction maskDeletedRowsFunction = this.deletedRows.map(deletedRows -> deletedRows.getMaskDeletedRowsFunction(page, startRowId)).orElseGet(() -> OrcDeletedRows.MaskDeletedRowsFunction.noMaskForPage(page));
        return this.getColumnAdaptationsPage(page, maskDeletedRowsFunction, this.recordReader.getFilePosition(), startRowId);
    }

    private Page getColumnAdaptationsPage(Page page, OrcDeletedRows.MaskDeletedRowsFunction maskDeletedRowsFunction, long filePosition, OptionalLong startRowId) {
        Block[] blocks = new Block[this.columnAdaptations.size()];
        for (int i = 0; i < this.columnAdaptations.size(); ++i) {
            blocks[i] = this.columnAdaptations.get(i).block(page, maskDeletedRowsFunction, filePosition, startRowId);
        }
        return new Page(maskDeletedRowsFunction.getPositionCount(), blocks);
    }

    static TrinoException handleException(OrcDataSourceId dataSourceId, Exception exception) {
        if (exception instanceof TrinoException) {
            return (TrinoException)((Object)exception);
        }
        if (exception instanceof OrcCorruptionException) {
            return new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)exception);
        }
        return new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, String.format("Failed to read ORC file: %s", dataSourceId), (Throwable)exception);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Closer closer = Closer.create();
        closer.register(() -> {
            this.stats.addMaxCombinedBytesPerRow(this.recordReader.getMaxCombinedBytesPerRow());
            this.recordReader.close();
        });
        closer.register(() -> {
            if (this.deletedRows.isPresent()) {
                this.deletedRows.get().close();
            }
        });
        try {
            closer.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("orcDataSource", (Object)this.orcDataSource.getId()).add("columns", this.columnAdaptations).toString();
    }

    public long getMemoryUsage() {
        return this.memoryContext.getBytes();
    }

    private static Block createRowNumberBlock(long startingRowId, long filePosition, int positionCount) {
        long[] translatedRowIds = new long[positionCount];
        for (int index = 0; index < positionCount; ++index) {
            translatedRowIds[index] = startingRowId + filePosition + (long)index;
        }
        return new LongArrayBlock(positionCount, Optional.empty(), translatedRowIds);
    }

    private static class PositionAdaptation
    implements ColumnAdaptation {
        private PositionAdaptation() {
        }

        @Override
        public Block block(Page sourcePage, OrcDeletedRows.MaskDeletedRowsFunction maskDeletedRowsFunction, long filePosition, OptionalLong startRowId) {
            Preconditions.checkArgument((boolean)startRowId.isEmpty(), (Object)"startRowId should not be specified when using PositionAdaptation");
            return OrcPageSource.createRowNumberBlock(0L, filePosition, sourcePage.getPositionCount());
        }
    }

    private static class ConstantAdaptation
    implements ColumnAdaptation {
        private final Block singleValueBlock;

        public ConstantAdaptation(Block singleValueBlock) {
            Objects.requireNonNull(singleValueBlock, "singleValueBlock is null");
            Preconditions.checkArgument((singleValueBlock.getPositionCount() == 1 ? 1 : 0) != 0, (Object)"ConstantColumnAdaptation singleValueBlock may only contain one position");
            this.singleValueBlock = singleValueBlock;
        }

        @Override
        public Block block(Page sourcePage, OrcDeletedRows.MaskDeletedRowsFunction maskDeletedRowsFunction, long filePosition, OptionalLong startRowId) {
            return new RunLengthEncodedBlock(this.singleValueBlock, sourcePage.getPositionCount());
        }
    }

    private static class OriginalFileRowIdAdaptation
    implements ColumnAdaptation {
        private final long startingRowId;
        private final Block bucketBlock;

        public OriginalFileRowIdAdaptation(long startingRowId, int bucketId) {
            this.startingRowId = startingRowId;
            this.bucketBlock = Utils.nativeValueToBlock((Type)IntegerType.INTEGER, (Object)OrcFileWriter.computeBucketValue(bucketId, 0));
        }

        @Override
        public Block block(Page sourcePage, OrcDeletedRows.MaskDeletedRowsFunction maskDeletedRowsFunction, long filePosition, OptionalLong startRowId) {
            int positionCount = sourcePage.getPositionCount();
            Block rowBlock = maskDeletedRowsFunction.apply(RowBlock.fromFieldBlocks((int)positionCount, Optional.empty(), (Block[])new Block[]{new RunLengthEncodedBlock(ORIGINAL_FILE_TRANSACTION_ID_BLOCK, positionCount), new RunLengthEncodedBlock(this.bucketBlock, positionCount), OrcPageSource.createRowNumberBlock(this.startingRowId, filePosition, positionCount)}));
            return rowBlock;
        }
    }

    private static final class UpdatedRowAdaptationWithOriginalFiles
    implements ColumnAdaptation {
        private final long startingRowId;
        private final Block bucketBlock;
        private final HiveUpdateProcessor updateProcessor;
        private final List<Integer> nonUpdatedSourceChannels;

        public UpdatedRowAdaptationWithOriginalFiles(long startingRowId, int bucketId, HiveUpdateProcessor updateProcessor, List<HiveColumnHandle> dependencyColumns) {
            this.startingRowId = startingRowId;
            this.bucketBlock = Utils.nativeValueToBlock((Type)IntegerType.INTEGER, (Object)OrcFileWriter.computeBucketValue(bucketId, 0));
            this.updateProcessor = Objects.requireNonNull(updateProcessor, "updateProcessor is null");
            Objects.requireNonNull(dependencyColumns, "dependencyColumns is null");
            this.nonUpdatedSourceChannels = updateProcessor.makeNonUpdatedSourceChannels(dependencyColumns);
        }

        @Override
        public Block block(Page sourcePage, OrcDeletedRows.MaskDeletedRowsFunction maskDeletedRowsFunction, long filePosition, OptionalLong startRowId) {
            int positionCount = sourcePage.getPositionCount();
            ImmutableList.Builder originalFilesBlockBuilder = ImmutableList.builder();
            originalFilesBlockBuilder.add((Object[])new Block[]{new RunLengthEncodedBlock(ORIGINAL_FILE_TRANSACTION_ID_BLOCK, positionCount), new RunLengthEncodedBlock(this.bucketBlock, positionCount), OrcPageSource.createRowNumberBlock(this.startingRowId, filePosition, positionCount)});
            for (int channel = 0; channel < sourcePage.getChannelCount(); ++channel) {
                originalFilesBlockBuilder.add((Object)sourcePage.getBlock(channel));
            }
            Page page = new Page((Block[])originalFilesBlockBuilder.build().toArray((Object[])new Block[0]));
            return this.updateProcessor.createUpdateRowBlock(page, this.nonUpdatedSourceChannels, maskDeletedRowsFunction);
        }
    }

    private static final class UpdatedRowAdaptation
    implements ColumnAdaptation {
        private final HiveUpdateProcessor updateProcessor;
        private final List<Integer> nonUpdatedSourceChannels;

        public UpdatedRowAdaptation(HiveUpdateProcessor updateProcessor, List<HiveColumnHandle> dependencyColumns) {
            this.updateProcessor = updateProcessor;
            this.nonUpdatedSourceChannels = updateProcessor.makeNonUpdatedSourceChannels(dependencyColumns);
        }

        @Override
        public Block block(Page sourcePage, OrcDeletedRows.MaskDeletedRowsFunction maskDeletedRowsFunction, long filePosition, OptionalLong startRowId) {
            return this.updateProcessor.createUpdateRowBlock(sourcePage, this.nonUpdatedSourceChannels, maskDeletedRowsFunction);
        }
    }

    private static class RowIdAdaptation
    implements ColumnAdaptation {
        private RowIdAdaptation() {
        }

        @Override
        public Block block(Page sourcePage, OrcDeletedRows.MaskDeletedRowsFunction maskDeletedRowsFunction, long filePosition, OptionalLong startRowId) {
            Block rowBlock = maskDeletedRowsFunction.apply(RowBlock.fromFieldBlocks((int)sourcePage.getPositionCount(), Optional.empty(), (Block[])new Block[]{sourcePage.getBlock(0), sourcePage.getBlock(1), sourcePage.getBlock(2)}));
            return rowBlock;
        }
    }

    private static class SourceColumn
    implements ColumnAdaptation {
        private final int index;

        public SourceColumn(int index) {
            Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"index is negative");
            this.index = index;
        }

        @Override
        public Block block(Page sourcePage, OrcDeletedRows.MaskDeletedRowsFunction maskDeletedRowsFunction, long filePosition, OptionalLong startRowId) {
            Block block = sourcePage.getBlock(this.index);
            return new LazyBlock(maskDeletedRowsFunction.getPositionCount(), (LazyBlockLoader)new MaskingBlockLoader(maskDeletedRowsFunction, block));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("index", this.index).toString();
        }

        private static final class MaskingBlockLoader
        implements LazyBlockLoader {
            private OrcDeletedRows.MaskDeletedRowsFunction maskDeletedRowsFunction;
            private Block sourceBlock;

            public MaskingBlockLoader(OrcDeletedRows.MaskDeletedRowsFunction maskDeletedRowsFunction, Block sourceBlock) {
                this.maskDeletedRowsFunction = Objects.requireNonNull(maskDeletedRowsFunction, "maskDeletedRowsFunction is null");
                this.sourceBlock = Objects.requireNonNull(sourceBlock, "sourceBlock is null");
            }

            public Block load() {
                Preconditions.checkState((this.maskDeletedRowsFunction != null ? 1 : 0) != 0, (Object)"Already loaded");
                Block resultBlock = this.maskDeletedRowsFunction.apply(this.sourceBlock.getLoadedBlock());
                this.maskDeletedRowsFunction = null;
                this.sourceBlock = null;
                return resultBlock;
            }
        }
    }

    private static class NullColumn
    implements ColumnAdaptation {
        private final Type type;
        private final Block nullBlock;

        public NullColumn(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.nullBlock = type.createBlockBuilder(null, 1, 0).appendNull().build();
        }

        @Override
        public Block block(Page sourcePage, OrcDeletedRows.MaskDeletedRowsFunction maskDeletedRowsFunction, long filePosition, OptionalLong startRowId) {
            return new RunLengthEncodedBlock(this.nullBlock, maskDeletedRowsFunction.getPositionCount());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).toString();
        }
    }

    public static interface ColumnAdaptation {
        public Block block(Page var1, OrcDeletedRows.MaskDeletedRowsFunction var2, long var3, OptionalLong var5);

        public static ColumnAdaptation nullColumn(Type type) {
            return new NullColumn(type);
        }

        public static ColumnAdaptation sourceColumn(int index) {
            return new SourceColumn(index);
        }

        public static ColumnAdaptation rowIdColumn() {
            return new RowIdAdaptation();
        }

        public static ColumnAdaptation originalFileRowIdColumn(long startingRowId, int bucketId) {
            return new OriginalFileRowIdAdaptation(startingRowId, bucketId);
        }

        public static ColumnAdaptation updatedRowColumnsWithOriginalFiles(long startingRowId, int bucketId, HiveUpdateProcessor updateProcessor, List<HiveColumnHandle> dependencyColumns) {
            return new UpdatedRowAdaptationWithOriginalFiles(startingRowId, bucketId, updateProcessor, dependencyColumns);
        }

        public static ColumnAdaptation updatedRowColumns(HiveUpdateProcessor updateProcessor, List<HiveColumnHandle> dependencyColumns) {
            return new UpdatedRowAdaptation(updateProcessor, dependencyColumns);
        }

        public static ColumnAdaptation constantColumn(Block singleValueBlock) {
            return new ConstantAdaptation(singleValueBlock);
        }

        public static ColumnAdaptation positionColumn() {
            return new PositionAdaptation();
        }
    }
}

