/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HivePartitionManager;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;

public final class PartitionMatchSupplier
implements BooleanSupplier {
    private final DynamicFilter dynamicFilter;
    private final HivePartition hivePartition;
    private final List<HiveColumnHandle> partitionColumns;
    @Nullable
    private volatile Boolean finalResult;

    private PartitionMatchSupplier(DynamicFilter dynamicFilter, HivePartition hivePartition, List<HiveColumnHandle> partitionColumns) {
        this.dynamicFilter = Objects.requireNonNull(dynamicFilter, "dynamicFilter is null");
        this.hivePartition = Objects.requireNonNull(hivePartition, "hivePartition is null");
        this.partitionColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionColumns, "partitionColumns is null"));
    }

    @Override
    public boolean getAsBoolean() {
        Boolean result = this.finalResult;
        if (result != null) {
            return result;
        }
        return this.evaluateCurrentDynamicFilter();
    }

    private boolean evaluateCurrentDynamicFilter() {
        boolean filterIsComplete = this.dynamicFilter.isComplete();
        TupleDomain currentPredicate = this.dynamicFilter.getCurrentPredicate();
        boolean partitionMatches = HivePartitionManager.partitionMatches(this.partitionColumns, (TupleDomain<ColumnHandle>)currentPredicate, this.hivePartition);
        if (!partitionMatches || filterIsComplete) {
            this.finalResult = partitionMatches;
        }
        return partitionMatches;
    }

    public static BooleanSupplier createPartitionMatchSupplier(DynamicFilter dynamicFilter, HivePartition hivePartition, List<HiveColumnHandle> partitionColumns) {
        Objects.requireNonNull(dynamicFilter, "dynamicFilter is null");
        Objects.requireNonNull(hivePartition, "hivePartition is null");
        Objects.requireNonNull(partitionColumns, "partitionColumns is null");
        if (partitionColumns.stream().noneMatch(dynamicFilter.getColumnsCovered()::contains)) {
            return new BooleanValueSupplier(true);
        }
        if (dynamicFilter.isComplete()) {
            return new BooleanValueSupplier(HivePartitionManager.partitionMatches(partitionColumns, (TupleDomain<ColumnHandle>)dynamicFilter.getCurrentPredicate(), hivePartition));
        }
        return new PartitionMatchSupplier(dynamicFilter, hivePartition, partitionColumns);
    }

    private static final class BooleanValueSupplier
    implements BooleanSupplier {
        private final boolean value;

        private BooleanValueSupplier(boolean value) {
            this.value = value;
        }

        @Override
        public boolean getAsBoolean() {
            return this.value;
        }
    }
}

