/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel;

import com.linkedin.coral.common.functions.FunctionFieldReferenceOperator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;

public class HiveSqlValidator
extends SqlValidatorImpl {
    public HiveSqlValidator(SqlOperatorTable opTab, CalciteCatalogReader catalogReader, JavaTypeFactory typeFactory, SqlConformance conformance) {
        super(opTab, (SqlValidatorCatalogReader)catalogReader, (RelDataTypeFactory)typeFactory, conformance);
        this.setDefaultNullCollation(NullCollation.LOW);
    }

    protected RelDataType getLogicalSourceRowType(RelDataType sourceRowType, SqlInsert insert) {
        RelDataType superType = super.getLogicalSourceRowType(sourceRowType, insert);
        return ((JavaTypeFactory)this.typeFactory).toSql(superType);
    }

    protected RelDataType getLogicalTargetRowType(RelDataType targetRowType, SqlInsert insert) {
        RelDataType superType = super.getLogicalTargetRowType(targetRowType, insert);
        return ((JavaTypeFactory)this.typeFactory).toSql(superType);
    }

    protected void inferUnknownTypes(RelDataType inferredType, SqlValidatorScope scope, SqlNode node) {
        if (SqlUtil.isNullLiteral((SqlNode)node, (boolean)false)) {
            this.setValidatedNodeType(node, this.typeFactory.createSqlType(SqlTypeName.NULL));
            return;
        }
        super.inferUnknownTypes(inferredType, scope, node);
    }

    public SqlNode expand(SqlNode expr, SqlValidatorScope scope) {
        SqlBasicCall dotCall;
        if (expr instanceof SqlBasicCall && ((SqlBasicCall)expr).getOperator().equals((Object)FunctionFieldReferenceOperator.DOT) && (dotCall = (SqlBasicCall)expr).operand(0) instanceof SqlBasicCall) {
            return expr;
        }
        return super.expand(expr, scope);
    }
}

