/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.store;

import alluxio.client.file.cache.PageStore;
import alluxio.client.file.cache.store.LocalPageStoreOptions;
import alluxio.client.file.cache.store.PageStoreType;
import alluxio.client.file.cache.store.RocksPageStoreOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import java.nio.file.Path;

public abstract class PageStoreOptions {
    protected String mRootDir;
    protected long mPageSize;
    protected long mCacheSize;
    protected String mAlluxioVersion;
    protected long mTimeoutDuration;
    protected int mTimeoutThreads;
    protected double mOverheadRatio;

    public static PageStoreOptions create(AlluxioConfiguration conf) {
        PageStoreOptions options;
        PageStoreType storeType = conf.getEnum(PropertyKey.USER_CLIENT_CACHE_STORE_TYPE, PageStoreType.class);
        switch (storeType) {
            case LOCAL: {
                options = new LocalPageStoreOptions().setFileBuckets(conf.getInt(PropertyKey.USER_CLIENT_CACHE_LOCAL_STORE_FILE_BUCKETS));
                break;
            }
            case ROCKS: {
                options = new RocksPageStoreOptions();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unrecognized store type %s", storeType.name()));
            }
        }
        Path rootDir = PageStore.getStorePath(storeType, conf.get(PropertyKey.USER_CLIENT_CACHE_DIR));
        options.setRootDir(rootDir.toString()).setPageSize(conf.getBytes(PropertyKey.USER_CLIENT_CACHE_PAGE_SIZE)).setCacheSize(conf.getBytes(PropertyKey.USER_CLIENT_CACHE_SIZE)).setAlluxioVersion(conf.get(PropertyKey.VERSION)).setTimeoutDuration(conf.getMs(PropertyKey.USER_CLIENT_CACHE_TIMEOUT_DURATION)).setTimeoutThreads(conf.getInt(PropertyKey.USER_CLIENT_CACHE_TIMEOUT_THREADS));
        if (conf.isSet(PropertyKey.USER_CLIENT_CACHE_STORE_OVERHEAD)) {
            options.setOverheadRatio(conf.getDouble(PropertyKey.USER_CLIENT_CACHE_STORE_OVERHEAD));
        }
        return options;
    }

    public abstract PageStoreType getType();

    public <T> T toOptions() {
        return (T)this;
    }

    public PageStoreOptions setRootDir(String rootDir) {
        this.mRootDir = rootDir;
        return this;
    }

    public String getRootDir() {
        return this.mRootDir;
    }

    public long getPageSize() {
        return this.mPageSize;
    }

    public PageStoreOptions setPageSize(long pageSize) {
        this.mPageSize = pageSize;
        return this;
    }

    public long getCacheSize() {
        return this.mCacheSize;
    }

    public PageStoreOptions setCacheSize(long cacheSize) {
        this.mCacheSize = cacheSize;
        return this;
    }

    public String getAlluxioVersion() {
        return this.mAlluxioVersion;
    }

    public PageStoreOptions setAlluxioVersion(String alluxioVersion) {
        this.mAlluxioVersion = alluxioVersion;
        return this;
    }

    public long getTimeoutDuration() {
        return this.mTimeoutDuration;
    }

    public PageStoreOptions setTimeoutDuration(long timeout) {
        this.mTimeoutDuration = timeout;
        return this;
    }

    public int getTimeoutThreads() {
        return this.mTimeoutThreads;
    }

    public PageStoreOptions setTimeoutThreads(int threads) {
        this.mTimeoutThreads = threads;
        return this;
    }

    public double getOverheadRatio() {
        return this.mOverheadRatio;
    }

    public PageStoreOptions setOverheadRatio(double overheadRatio) {
        this.mOverheadRatio = overheadRatio;
        return this;
    }
}

