/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import io.trino.hadoop.$internal.com.google.common.base.Preconditions;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class FsUrlConnection
extends URLConnection {
    private static final Logger LOG = LoggerFactory.getLogger(FsUrlConnection.class);
    private Configuration conf;
    private InputStream is;

    FsUrlConnection(Configuration conf, URL url) {
        super(url);
        Preconditions.checkArgument(conf != null, "null conf argument");
        Preconditions.checkArgument(url != null, "null url argument");
        this.conf = conf;
    }

    @Override
    public void connect() throws IOException {
        Preconditions.checkState(this.is == null, "Already connected");
        try {
            LOG.debug("Connecting to {}", (Object)this.url);
            FileSystem fs = FileSystem.get(this.url.toURI(), this.conf);
            this.is = fs.open(new Path(this.url.toURI()));
        }
        catch (URISyntaxException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.is == null) {
            this.connect();
        }
        return this.is;
    }
}

