/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common.functions;

import com.google.common.base.Preconditions;
import com.linkedin.coral.com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransform;
import org.apache.calcite.sql.type.SqlTypeTransforms;

public final class FunctionReturnTypes {
    public static final SqlReturnTypeInference IF_FUNC_RETURN_TYPE = opBinding -> {
        Preconditions.checkState((opBinding.getOperandCount() == 3 ? 1 : 0) != 0);
        RelDataType type1 = opBinding.getOperandType(1);
        RelDataType type2 = opBinding.getOperandType(2);
        if (type1 == type2) {
            return type1;
        }
        return opBinding.isOperandLiteral(1, false) ? type2 : type1;
    };
    public static final SqlReturnTypeInference STRING = ReturnTypes.explicit((SqlTypeName)SqlTypeName.VARCHAR);
    public static final SqlReturnTypeInference BINARY = ReturnTypes.explicit((SqlTypeName)SqlTypeName.BINARY);
    public static final SqlReturnTypeInference SMALLINT = ReturnTypes.explicit((SqlTypeName)SqlTypeName.SMALLINT);
    public static final SqlReturnTypeInference TIMESTAMP = ReturnTypes.explicit((SqlTypeName)SqlTypeName.TIMESTAMP);
    public static final SqlReturnTypeInference ARRAY_OF_STR_STR_MAP = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType strType = typeFactory.createSqlType(SqlTypeName.VARCHAR);
        return typeFactory.createArrayType(typeFactory.createMapType(strType, strType), -1L);
    };
    public static final SqlReturnTypeInference ARRAY_OF_ARG0_TYPE = opBinding -> opBinding.getTypeFactory().createArrayType(opBinding.getOperandType(0), -1L);

    private FunctionReturnTypes() {
    }

    public static SqlReturnTypeInference arrayOfType(SqlTypeName typeName) {
        return FunctionReturnTypes.arrayOfType(typeName, false);
    }

    public static SqlReturnTypeInference arrayOfType(SqlTypeName typeName, boolean elementsNullable) {
        return opBinding -> {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType relType = elementsNullable ? ReturnTypes.cascade((SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)typeName), (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.TO_NULLABLE}).inferReturnType(opBinding) : typeFactory.createSqlType(typeName);
            return typeFactory.createArrayType(relType, -1L);
        };
    }

    public static SqlReturnTypeInference mapOfType(SqlTypeName keyType, SqlTypeName valueType) {
        return opBinding -> {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createMapType(typeFactory.createSqlType(keyType), typeFactory.createSqlType(valueType));
        };
    }

    public static SqlReturnTypeInference rowOf(ImmutableList<String> fieldNames, ImmutableList<SqlTypeName> types) {
        return opBinding -> {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            List relTypes = types.stream().map(arg_0 -> ((RelDataTypeFactory)typeFactory).createSqlType(arg_0)).collect(Collectors.toList());
            return typeFactory.createStructType(relTypes, (List)fieldNames);
        };
    }

    public static SqlReturnTypeInference rowOfInference(ImmutableList<String> fieldNames, ImmutableList<SqlReturnTypeInference> types) {
        return opBinding -> {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            List relTypes = types.stream().map(t -> t.inferReturnType(opBinding)).collect(Collectors.toList());
            return typeFactory.createStructType(relTypes, (List)fieldNames);
        };
    }
}

