/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.io;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.JsonWriter;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class PartitionSerializer
implements JsonWriter.Serializer {
    public static final String FIELD_NAME = "partitions";
    private Partition partition;

    PartitionSerializer(Partition partition) {
        this.partition = partition;
    }

    @Override
    public void writeTo(JsonWriter writer, ReplicationSpec additionalPropertiesProvider) throws SemanticException, IOException {
        TSerializer serializer = new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
        try {
            Map<String, String> parameters = this.partition.getParameters();
            if (parameters != null) {
                parameters.entrySet().removeIf(e -> ((String)e.getKey()).equals("hive.repl.ckpt.key"));
            }
            if (additionalPropertiesProvider.isInReplicationScope()) {
                if (additionalPropertiesProvider.getReplSpecType() != ReplicationSpec.Type.INCREMENTAL_DUMP) {
                    this.partition.putToParameters(ReplicationSpec.KEY.CURR_STATE_ID.toString(), additionalPropertiesProvider.getCurrentReplicationState());
                }
                if (this.isPartitionExternal()) {
                    this.partition.putToParameters("EXTERNAL", "FALSE");
                }
            }
            writer.jsonGenerator.writeString(serializer.toString((TBase)this.partition, "UTF-8"));
            writer.jsonGenerator.flush();
        }
        catch (TException e2) {
            throw new SemanticException(ErrorMsg.ERROR_SERIALIZE_METASTORE.getMsg(), e2);
        }
    }

    private boolean isPartitionExternal() {
        Map<String, String> params = this.partition.getParameters();
        return params.containsKey("EXTERNAL") && params.get("EXTERNAL").equalsIgnoreCase("TRUE");
    }
}

