/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.statistics;

import com.google.common.base.MoreObjects;
import io.airlift.log.Logger;
import io.airlift.slice.SizeOf;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.transactionlog.CanonicalColumnName;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeFileStatistics;
import io.trino.spi.block.Block;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class DeltaLakeParquetFileStatistics
implements DeltaLakeFileStatistics {
    private static final Logger log = Logger.get(DeltaLakeParquetFileStatistics.class);
    private static final long INSTANCE_SIZE = ClassLayout.parseClass(DeltaLakeParquetFileStatistics.class).instanceSize();
    private final Optional<Long> numRecords;
    private final Optional<Map<CanonicalColumnName, Object>> minValues;
    private final Optional<Map<CanonicalColumnName, Object>> maxValues;
    private final Optional<Map<CanonicalColumnName, Object>> nullCount;

    public DeltaLakeParquetFileStatistics(Optional<Long> numRecords, Optional<Map<String, Object>> minValues, Optional<Map<String, Object>> maxValues, Optional<Map<String, Object>> nullCount) {
        this.numRecords = numRecords;
        Map<String, CanonicalColumnName> canonicalColumnNames = DeltaLakeFileStatistics.getCanonicalColumnNames(minValues, maxValues, nullCount);
        this.minValues = minValues.map(minValuesMap -> TransactionLogAccess.toCanonicalNameKeyedMap(minValuesMap, canonicalColumnNames));
        this.maxValues = maxValues.map(maxValuesMap -> TransactionLogAccess.toCanonicalNameKeyedMap(maxValuesMap, canonicalColumnNames));
        this.nullCount = nullCount.map(nullCountMap -> TransactionLogAccess.toCanonicalNameKeyedMap(nullCountMap, canonicalColumnNames));
    }

    @Override
    public Optional<Long> getNumRecords() {
        return this.numRecords;
    }

    public Optional<Map<String, Object>> getMinValues() {
        return this.minValues.map(TransactionLogAccess::toOriginalNameKeyedMap);
    }

    public Optional<Map<String, Object>> getMaxValues() {
        return this.maxValues.map(TransactionLogAccess::toOriginalNameKeyedMap);
    }

    public Optional<Map<String, Object>> getNullCount() {
        return this.nullCount.map(TransactionLogAccess::toOriginalNameKeyedMap);
    }

    @Override
    public Optional<Object> getMaxColumnValue(DeltaLakeColumnHandle columnHandle) {
        return this.getStat(columnHandle.getName(), this.maxValues);
    }

    @Override
    public Optional<Object> getMinColumnValue(DeltaLakeColumnHandle columnHandle) {
        return this.getStat(columnHandle.getName(), this.minValues);
    }

    @Override
    public Optional<Long> getNullCount(String columnName) {
        return this.getStat(columnName, this.nullCount).map(o -> Long.valueOf(o.toString()));
    }

    private Optional<Object> getStat(String columnName, Optional<Map<CanonicalColumnName, Object>> stats) {
        if (stats.isEmpty()) {
            return Optional.empty();
        }
        CanonicalColumnName canonicalColumnName = new CanonicalColumnName(columnName);
        Object contents = stats.get().get(canonicalColumnName);
        if (contents == null) {
            return Optional.empty();
        }
        if (contents instanceof List || contents instanceof Map || contents instanceof Block) {
            log.debug("Skipping statistics value for column with complex value type: %s", new Object[]{columnName});
            return Optional.empty();
        }
        return Optional.of(contents);
    }

    @Override
    public long getRetainedSizeInBytes() {
        long totalSize = INSTANCE_SIZE;
        if (this.minValues.isPresent()) {
            totalSize += SizeOf.estimatedSizeOf(this.minValues.get(), CanonicalColumnName::getRetainedSize, DeltaLakeParquetFileStatistics::sizeOfMinMaxStatsEntry);
        }
        if (this.maxValues.isPresent()) {
            totalSize += SizeOf.estimatedSizeOf(this.maxValues.get(), CanonicalColumnName::getRetainedSize, DeltaLakeParquetFileStatistics::sizeOfMinMaxStatsEntry);
        }
        if (this.nullCount.isPresent()) {
            totalSize += SizeOf.estimatedSizeOf(this.nullCount.get(), CanonicalColumnName::getRetainedSize, DeltaLakeParquetFileStatistics::sizeOfNullCountStatsEntry);
        }
        return totalSize;
    }

    private static long sizeOfMinMaxStatsEntry(Object value) {
        if (value instanceof Block) {
            return ((Block)value).getRetainedSizeInBytes();
        }
        return SizeOf.sizeOfObjectArray((int)1);
    }

    private static long sizeOfNullCountStatsEntry(Object value) {
        if (value instanceof Block) {
            return ((Block)value).getRetainedSizeInBytes();
        }
        return SizeOf.sizeOfLongArray((int)1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeltaLakeParquetFileStatistics that = (DeltaLakeParquetFileStatistics)o;
        return Objects.equals(this.numRecords, that.numRecords) && Objects.equals(this.minValues, that.minValues) && Objects.equals(this.maxValues, that.maxValues) && Objects.equals(this.nullCount, that.nullCount);
    }

    public int hashCode() {
        return Objects.hash(this.numRecords, this.minValues, this.maxValues, this.nullCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numRecords", this.numRecords).add("minValues", this.minValues).add("maxValues", this.maxValues).add("nullCount", this.nullCount).toString();
    }
}

